/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.data.Location;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import com.google.common.collect.Queues;
import java.util.BitSet;
import java.util.Deque;
import org.objectweb.asm.ClassWriter;

public class TypeStack {
    private final Deque<TypeContext> quack = Queues.newArrayDeque();

    public void push(TypeContext clazz) {
        this.quack.push(clazz);
    }

    public void pop() {
        TypeContext clazz = this.quack.pop();
        clazz.classWriter.visitEnd();
    }

    public TypeContext peek() {
        return this.quack.peek();
    }

    public boolean isEmpty() {
        return this.quack.isEmpty();
    }

    public void clear() {
        this.quack.clear();
    }

    public static class TypeContext {
        private final TypeInfo type;
        private final Location loc;
        private final ClassWriter classWriter;
        private final BitSet additionalCodeLocations;
        private final BitSet suppressedCodeLocations;
        private final BitSet knownCodeLocations;

        private TypeContext(Builder builder) {
            this.type = builder.type;
            this.loc = this.type.getModifiers().getLoc();
            this.classWriter = builder.classWriter;
            int javaModifiers = this.type.getModifiers().getJavaModifiers() & (TypeInfoUtil.isTopLevel(this.type) ? -3 : Integer.MAX_VALUE) | 0x20;
            this.classWriter.visit(196653, javaModifiers, this.type.getBytecodeName(), null, TypeEraser.eraseBytecodeNameWithNullCheck(this.type.parents().superType()), TypeEraser.eraseBytecodeNames(this.type.parents().immediateInterfaces()));
            this.knownCodeLocations = new BitSet();
            this.additionalCodeLocations = new BitSet();
            this.suppressedCodeLocations = new BitSet();
        }

        public static Builder builder() {
            return new Builder();
        }

        public TypeInfo getType() {
            return this.type;
        }

        public CodeUnitDetails getCodeUnitDetails() {
            return this.type.getCodeUnitDetails();
        }

        public Location getLoc() {
            return this.loc;
        }

        public ClassWriter getClassWriter() {
            return this.classWriter;
        }

        public boolean addAdditionalCodeLocation(int line) {
            this.suppressedCodeLocations.clear(line);
            this.knownCodeLocations.set(line);
            boolean previous = this.additionalCodeLocations.get(line);
            this.additionalCodeLocations.set(line);
            return previous;
        }

        public void addSuppressedCodeLocation(int line) {
            if (this.additionalCodeLocations.get(line)) {
                return;
            }
            this.suppressedCodeLocations.set(line);
        }

        public void removeSuppressedCodeLocation(int line) {
            this.suppressedCodeLocations.clear(line);
        }

        public BitSet getAdditionalCodeLocations() {
            return this.additionalCodeLocations;
        }

        public BitSet getSuppressedCodeLocations() {
            return this.suppressedCodeLocations;
        }

        public boolean setKnownCodeLocations(int line) {
            boolean oldValue = this.knownCodeLocations.get(line);
            this.knownCodeLocations.set(line);
            return !oldValue;
        }

        public BitSet getKnownCodeLocations() {
            this.knownCodeLocations.xor(this.suppressedCodeLocations);
            return this.knownCodeLocations;
        }

        public static class Builder {
            private TypeInfo type;
            private ClassWriter classWriter;

            private Builder() {
            }

            public TypeContext build() {
                this.classWriter = this.classWriter == null ? new ClassWriter(1) : this.classWriter;
                return new TypeContext(this);
            }

            public Builder setClassWriter(ClassWriter classWriter) {
                this.classWriter = classWriter;
                return this;
            }

            public Builder setType(TypeInfo type) {
                this.type = type;
                return this;
            }
        }
    }
}

