/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common.iterable;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Queues;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class InnerTypeIterable
implements Iterable<TypeInfo> {
    private final Deque<CompilationOutput> toVisit = Queues.newArrayDeque();

    @VisibleForTesting
    InnerTypeIterable(CompilationOutput output) {
        if (output != null) {
            this.toVisit.push(output);
        }
    }

    @SfdcCalled
    public static InnerTypeIterable create(CodeUnit unit) {
        return new InnerTypeIterable(unit.getOutput());
    }

    @SfdcCalled
    public static InnerTypeIterable create(CompilationOutput output) {
        return new InnerTypeIterable(output);
    }

    @Override
    public Iterator<TypeInfo> iterator() {
        return new Iterator<TypeInfo>(){

            @Override
            public boolean hasNext() {
                return !InnerTypeIterable.this.toVisit.isEmpty();
            }

            @Override
            public TypeInfo next() {
                if (InnerTypeIterable.this.toVisit.isEmpty()) {
                    throw new NoSuchElementException();
                }
                CompilationOutput output = (CompilationOutput)InnerTypeIterable.this.toVisit.remove();
                for (CompilationOutput innerOutput : output.getInnerOutputs().values()) {
                    InnerTypeIterable.this.toVisit.push(innerOutput);
                }
                return output.getType();
            }
        };
    }
}

