/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.common.base.MoreStrings;
import apex.common.base.Result;
import apex.common.collect.MoreIterables;
import apex.jorje.data.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CompilerService;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import apex.jorje.semantic.compiler.sfdc.SymbolProvider;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldTables;
import apex.jorje.semantic.symbol.member.variable.LocalVariableTable;
import apex.jorje.semantic.symbol.member.variable.TriggerVariable;
import apex.jorje.semantic.symbol.member.variable.TriggerVariableMap;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.FieldContext;
import apex.jorje.semantic.symbol.resolver.MethodResolver;
import apex.jorje.semantic.symbol.resolver.StaticContext;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.TypeRefResolver;
import apex.jorje.semantic.symbol.resolver.TypeRefResolvers;
import apex.jorje.semantic.symbol.resolver.VariableResolver;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrder;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrderUtil;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolutionOrders;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameParser;
import apex.jorje.services.Version;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MoreLists;
import com.google.common.collect.MoreMaps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StandardSymbolResolver
implements SymbolResolver {
    private static final Function<Identifier, String> TO_NAME = Identifier::getValue;
    private final ApexCompiler compiler;
    private final Map<String, TypeInfo> compiledTypesByLowerName;
    private final TriggerVariableMap triggerVariableMap;
    private final Map<String, TypeInfo> labelTypes;
    private final TypeInfo pageType;
    private final Map<InternalTypeInfo, TypeInfo> internalTypeToActualType;
    private static final LookupOnResolver STANDARD_LOOKUP = (resolver, referencingType, type) -> resolver.lookupTypeInfo(referencingType, TypeNameResolutionOrders.DEFAULT, type.getLookupName());
    private final LookupOnResolver lookupOnResolver;

    public StandardSymbolResolver(ApexCompiler compiler) {
        this(compiler, STANDARD_LOOKUP, new HashMap<InternalTypeInfo, TypeInfo>());
    }

    @VisibleForTesting
    StandardSymbolResolver(ApexCompiler compiler, LookupOnResolver lookupOnResolver, Map<InternalTypeInfo, TypeInfo> internalTypeToActualType) {
        this.compiler = compiler;
        this.compiledTypesByLowerName = MoreMaps.newCaseInsensitiveMap();
        this.labelTypes = MoreMaps.newCaseInsensitiveMap();
        this.triggerVariableMap = new TriggerVariableMap();
        this.pageType = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName("System.Page")).setBytecodeName("com/salesforce/api/System/Page")).setModifiers(ModifierGroups.HIDDEN)).setFields(DynamicFieldTables.createPageTable())).buildResolved();
        this.internalTypeToActualType = internalTypeToActualType;
        this.lookupOnResolver = lookupOnResolver;
    }

    static Optional<List<String>> adjustEmptyNames(List<String> names, Version version) {
        if (version.isGreaterThan(Version.V196) || names.isEmpty() || MoreIterables.getFirst(names).isEmpty() || Iterables.getLast(names).isEmpty()) {
            return Optional.empty();
        }
        ImmutableList.Builder adjustedNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < names.size() - 1; ++i) {
            String name = names.get(i);
            String nextName = names.get(i + 1);
            if (!name.isEmpty()) {
                adjustedNamesBuilder.add(name);
                continue;
            }
            if (!name.isEmpty() || !nextName.isEmpty()) continue;
            return Optional.empty();
        }
        adjustedNamesBuilder.add(Iterables.getLast(names));
        return Optional.of(adjustedNamesBuilder.build());
    }

    @Override
    public TypeInfo lookupTypeInfo(TypeInfo referencingType, InternalTypeInfo type) {
        TypeInfo typeInfo = this.internalTypeToActualType.get(type);
        if (typeInfo == null) {
            typeInfo = this.lookupOnResolver.lookup(this, referencingType, type);
            this.internalTypeToActualType.put(type, typeInfo);
        }
        return typeInfo;
    }

    @Override
    public TypeInfo lookupInjectedTypeInfo(TypeInfo referencingType, String bytecodeName) {
        return this.lookupInjectedTypeInfo(referencingType, TypeNameParser.parseBytecodeName(bytecodeName));
    }

    @Override
    public TypeInfo lookupTypeInfo(TypeInfo referencingType, TypeRef typeRef) {
        TypeRefResolver resolver = TypeRefResolvers.get(typeRef);
        return resolver.resolve(this, referencingType, typeRef, ReferenceType.NONE);
    }

    @Override
    public TypeInfo lookupTypeInfo(TypeInfo referencingType, TypeRef typeRef, ReferenceType reference) {
        TypeRefResolver resolver = TypeRefResolvers.get(typeRef);
        return resolver.resolve(this, referencingType, typeRef, reference);
    }

    @Override
    public TypeInfo lookupTypeInfoIdentifiers(TypeInfo referencingType, List<Identifier> names) {
        return this.lookupTypeInfo(referencingType, TypeNameResolutionOrders.DEFAULT, Lists.transform(names, TO_NAME));
    }

    @Override
    public TypeInfo lookupTypeInfo(TypeInfo referencingType, List<String> names) {
        return this.lookupTypeInfo(referencingType, TypeNameResolutionOrders.DEFAULT, names);
    }

    @Override
    public TypeInfo lookupTypeInfoIdentifiers(TypeInfo referencingType, List<Identifier> names, ReferenceType reference) {
        return this.lookupTypeInfo(referencingType, TypeNameResolutionOrders.get(reference), Lists.transform(names, TO_NAME));
    }

    @Override
    public Result<MethodInfo> lookupMethodInfo(TypeInfo referencingType, IdentifierContext context, TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        return new MethodResolver(referencingType).lookup(context, type, methodName, parameterTypes);
    }

    @Override
    public Variable lookupVariableInfo(TypeInfo referencingType, ReferenceType referenceType, IdentifierContext context, TypeInfo type, Identifier name) {
        return new VariableResolver(this, referencingType).lookup(referenceType, context, type, name);
    }

    @Override
    public List<Variable> lookupVariableInfo(TypeInfo referencingType, ReferenceType referenceType, IdentifierContext context, TypeInfo type, List<Identifier> names) {
        return new VariableResolver(this, referencingType).lookup(referenceType, context, type, names);
    }

    @Override
    public VariableResolver.StaticResult lookupStaticVariableInfo(TypeInfo referencingType, ReferenceType referenceType, List<Identifier> names) {
        return new VariableResolver(this, referencingType).lookupStatic(referenceType, names);
    }

    @Override
    public boolean add(TypeInfo type) {
        String name = type.getBytecodeName();
        if (!this.compiledTypesByLowerName.containsKey(name)) {
            this.compiledTypesByLowerName.put(name, type);
            return false;
        }
        return true;
    }

    @Override
    public TypeInfo get(String fullNameLower) {
        return this.compiledTypesByLowerName.get(fullNameLower);
    }

    @Override
    public LocalVariableTable variables() {
        return this.compiler.getCompilerContext().variables();
    }

    @Override
    public StaticContext staticContext() {
        return this.compiler.getCompilerContext().staticContext();
    }

    @Override
    public FieldContext fields() {
        return this.compiler.getCompilerContext().fieldContext();
    }

    @Override
    public SymbolProvider getSymbolProvider() {
        return this.compiler.getInput().getSymbolProvider();
    }

    @Override
    public AccessEvaluator getAccessEvaluator() {
        return this.compiler.getInput().getAccessEvaluator();
    }

    @Override
    public QueryValidator getQueryValidator() {
        return this.compiler.getInput().getQueryValidator();
    }

    @Override
    public CompilerService getCompilerService() {
        return this.compiler;
    }

    @Override
    public TriggerVariable getTriggerVariable(TypeInfo referencingType, String name) {
        TypeInfo targetType = TypeInfoUtil.getTopLevel(referencingType).getCodeUnitDetails().getTriggerType().resolve(this, referencingType);
        return targetType == null || !targetType.isResolved() ? null : this.triggerVariableMap.get(referencingType, targetType, name);
    }

    @Override
    public TypeInfo getLabelTypeInfo(Namespace namespace) {
        TypeInfo type = this.labelTypes.get(namespace.getNameLower());
        if (type == null) {
            type = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName("System.Label")).setBytecodeName("com/salesforce/api/System/Label")).setModifiers(ModifierGroups.HIDDEN)).setNamespace(Namespaces.SYSTEM)).setFields(DynamicFieldTables.createLabelTable(namespace))).buildResolved();
            this.labelTypes.put(namespace.getNameLower(), type);
        }
        return type;
    }

    @Override
    public TypeInfo getPageTypeInfo() {
        return this.pageType;
    }

    @VisibleForTesting
    TypeInfo lookupInjectedTypeInfo(TypeInfo referencingType, TypeNameParser.TypeName typeName) {
        TypeInfo type = this.findFullyQualified(referencingType, typeName.getName().toLowerCase());
        if (typeName.getArguments().isEmpty()) {
            return type;
        }
        List<TypeInfo> builder = typeName.getArguments().stream().map(typeArgument -> this.lookupInjectedTypeInfo(referencingType, (TypeNameParser.TypeName)typeArgument)).collect(MoreLists.toImmutableList(typeName.getArguments().size()));
        return GenericTypeInfoFactory.create(this, type, builder);
    }

    private TypeInfo lookupTypeInfo(TypeInfo referencingType, TypeNameResolutionOrder order, List<String> names) {
        List<String> adjustedNames = names;
        if (MoreIterables.ensureAny(names, String::isEmpty)) {
            Optional<List<String>> adjustedNamesResult = StandardSymbolResolver.adjustEmptyNames(names, referencingType.getCodeUnitDetails().getVersion());
            if (adjustedNamesResult.isPresent()) {
                adjustedNames = adjustedNamesResult.get();
            } else {
                return UnresolvedTypeInfoFactory.create(names);
            }
        }
        if (adjustedNames.size() > 4) {
            return UnresolvedTypeInfoFactory.create(adjustedNames);
        }
        if ("__sfdc_trigger".equalsIgnoreCase(adjustedNames.get(0))) {
            return UnresolvedTypeInfoFactory.create(adjustedNames);
        }
        TypeInfo type = TypeNameResolutionOrderUtil.get().bindToType(this, referencingType, order, adjustedNames);
        if (type != null) {
            assert (type.isResolved()) : "we bound to a type that wasn't resolved";
            return type;
        }
        return UnresolvedTypeInfoFactory.create(adjustedNames);
    }

    private TypeInfo findFullyQualified(TypeInfo referencingType, String lowerCaseFullName) {
        assert (MoreStrings.isLowerCase(lowerCaseFullName));
        TypeInfo type = this.compiledTypesByLowerName.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        type = TypeInfoTables.TYPES_BY_BYTECODE_NAME.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        type = this.compiler.getInput().getSymbolProvider().find(this, referencingType, lowerCaseFullName);
        if (type != null) {
            return type;
        }
        return UnresolvedTypeInfoFactory.create(lowerCaseFullName);
    }

    public TypeInfo find(TypeInfo referencingType, String lowerCaseFullName) {
        assert (MoreStrings.isLowerCase(lowerCaseFullName));
        TypeInfo type = TypeInfoTables.WRAPPER_TYPES.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        if (this.pageType.getBytecodeName().equalsIgnoreCase(lowerCaseFullName)) {
            return this.pageType;
        }
        type = this.compiledTypesByLowerName.get(lowerCaseFullName);
        if (type != null) {
            return type;
        }
        type = this.compiler.getInput().getSymbolProvider().find(this, referencingType, lowerCaseFullName);
        if (type != null && type.isResolved()) {
            return type;
        }
        return null;
    }

    @VisibleForTesting
    ApexCompiler getCompiler() {
        return this.compiler;
    }

    @VisibleForTesting
    static interface LookupOnResolver {
        public TypeInfo lookup(StandardSymbolResolver var1, TypeInfo var2, InternalTypeInfo var3);
    }
}

