/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRuleGroup;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.AnnotationProperty;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.semantic.symbol.type.visitor.ModifierOrAnnotationVisitor;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ModifierTypeInfo
extends AbstractTypeInfo
implements ModifierOrAnnotationTypeInfo {
    private final boolean isBytecodeVisible;
    private final int opcode;
    private final Supplier<AnnotationRuleGroup> ruleGroup;

    private ModifierTypeInfo(Builder builder) {
        super(builder);
        this.opcode = builder.opcode;
        this.isBytecodeVisible = builder.isBytecodeVisible;
        this.ruleGroup = builder.ruleGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public <T> T accept(ModifierOrAnnotationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Map<String, AnnotationProperty> getProperties() {
        return ImmutableMap.of();
    }

    @Override
    public AnnotationRuleGroup getRuleGroup() {
        return this.ruleGroup.get();
    }

    @Override
    public boolean isBytecodeVisible() {
        return this.isBytecodeVisible;
    }

    @Override
    public boolean shouldForceEmitAnnotationString() {
        return false;
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public ModifierGroup getModifiers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getBytecodeName();
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, ModifierTypeInfo> {
        private int opcode = 0;
        private boolean isBytecodeVisible = false;
        private Supplier<AnnotationRuleGroup> ruleGroup;

        private Builder() {
        }

        @Override
        public ModifierTypeInfo build() {
            this.setApexName(this.getBytecodeName());
            this.setBasicType(BasicType.MODIFIER);
            this.setUnitType(UnitType.ANNOTATION);
            this.setParents(StandardParentTable.EMPTY);
            this.setFields(FieldTable.EMPTY);
            this.setMethods(StandardMethodTable.EMPTY);
            this.setNamespace(Namespaces.EMPTY);
            this.setModifiers(ModifierGroup.builder().build());
            return new ModifierTypeInfo(this);
        }

        public Builder setOpcode(int opcode) {
            this.opcode = opcode;
            return this;
        }

        public Builder setBytecodeVisible(boolean bytecodeVisible) {
            this.isBytecodeVisible = bytecodeVisible;
            return this;
        }

        public Builder setRuleGroup(Supplier<AnnotationRuleGroup> ruleGroup) {
            this.ruleGroup = Suppliers.memoize(ruleGroup);
            return this;
        }

        public Builder setRuleGroup(AnnotationRuleGroup ruleGroup) {
            return this.setRuleGroup(Suppliers.ofInstance(ruleGroup));
        }
    }
}

