/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.VisibilityUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class MethodCallVisibility {
    public static List<String> calculate(TypeInfo referencingType, AccessEvaluator accessEvaluator, Visibility.ReferencedFromTestMethod referencedFromTestMethod, MethodInfo method) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        boolean isSfdcOnlyVisible = VisibilityUtil.isMemberSfdcOnlyVisible(accessEvaluator, referencingType, method.getDefiningType(), method.getModifiers(), method.getJavaSfdcOnlyAnnotation());
        if (!isSfdcOnlyVisible && method.isConstructor() && method.getDefiningType().getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) && method.getGenerated() != Generated.USER && referencingType.getCodeUnitDetails().getVersion().isLessThan(Version.V186)) {
            return ImmutableList.of();
        }
        if (!(isSfdcOnlyVisible && VisibilityUtil.isMethodPrivateApiVisible(accessEvaluator, method.getModifiers(), method.getDefiningType().getModifiers()) && VisibilityUtil.isMethodAllowCertifiedApexVisible(referencingType, accessEvaluator, method.getModifiers(), method.getDefiningType().getModifiers()) && Visibility.isMethodVisible(accessEvaluator, referencingType, method, referencedFromTestMethod))) {
            errorMessages.add(I18nSupport.getLabel("method.not.visible", method));
            return errorMessages;
        }
        if (MethodCallVisibility.shouldCheckParamsAndReturnTypes(method, referencingType.getCodeUnitDetails().getVersion())) {
            boolean isReturnTypeNotVisible;
            boolean bl = isReturnTypeNotVisible = !Visibility.isTypeVisibleInImplicitReference(accessEvaluator, referencingType, method.getReturnType(), referencedFromTestMethod, Visibility.CheckGenericTypeArguments.NO);
            if (isReturnTypeNotVisible) {
                errorMessages.add(I18nSupport.getLabel("method.return.type.not.visible", method.getReturnType(), method.getSignature()));
            }
            for (TypeInfo parameterType : method.getParameterTypes()) {
                boolean isParameterTypeNotVisible = !Visibility.isTypeVisible(accessEvaluator, referencingType, parameterType, referencedFromTestMethod, Visibility.CheckGenericTypeArguments.NO);
                if (!isParameterTypeNotVisible) continue;
                errorMessages.add(I18nSupport.getLabel("method.parameter.type.not.visible", parameterType, method.getSignature()));
            }
        }
        return errorMessages;
    }

    private static boolean shouldCheckParamsAndReturnTypes(MethodInfo method, Version referencingVersion) {
        Version methodVersion = method.getDefiningType().getCodeUnitDetails().getVersion();
        boolean isAConstructorReferredPriorToCompilerRelease = method.isConstructor() && referencingVersion.isLessThanOrEqual(Version.COMPILER_RELEASE) && methodVersion.isLessThanOrEqual(Version.COMPILER_RELEASE);
        return method.getDefiningType().getBasicType().isApexObject() && !isAConstructorReferredPriorToCompilerRelease;
    }
}

