/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.common.tuple.IntPair;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Map;

public class PackageVersionVisibility {
    public static boolean isPackageVersionVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, TypeInfo targetDefiningType, Location targetLoc) {
        if (!(referencingType.getCodeUnitDetails().isApexSourceBased() && targetDefiningType.getCodeUnitDetails().isApexSourceBased() && Locations.isReal(targetLoc) && accessEvaluator.isManagedPackageInstalled(targetDefiningType.getNamespace()) && !Namespace.equals(referencingType, targetDefiningType))) {
            return true;
        }
        return PackageVersionVisibility.isPackageVersionVisible(referencingType.getCodeUnitDetails().getReferencedPackageVersions(), targetDefiningType.getCodeUnitDetails().getExportedPackageVersions(), targetDefiningType.getNamespace(), targetLoc);
    }

    static boolean isPackageVersionVisible(Map<Namespace, StructuredVersion> referencedPackagesMap, Map<IntPair, StructuredVersionRange> exportedVersionsMap, Namespace targetNamespace, Location targetLoc) {
        StructuredVersion importedVersion = referencedPackagesMap.get(targetNamespace);
        if (importedVersion == null) {
            return true;
        }
        StructuredVersionRange exportedStructuredVersionRange = exportedVersionsMap.get(Locations.toPair(targetLoc));
        return exportedStructuredVersionRange == null || exportedStructuredVersionRange.within(importedVersion);
    }
}

