/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility.legacy.loopholes;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.legacy.loopholes.PropertyLoophole;
import apex.jorje.services.Version;

class ParentSetterVisible
implements PropertyLoophole {
    private static final ParentSetterVisible INSTANCE = new ParentSetterVisible();

    private ParentSetterVisible() {
    }

    public static ParentSetterVisible get() {
        return INSTANCE;
    }

    private static boolean isGlobalOrPublicOrProtected(ModifierGroup modifierGroup) {
        return modifierGroup.has(ModifierTypeInfos.GLOBAL) || modifierGroup.has(ModifierTypeInfos.PUBLIC) || modifierGroup.has(ModifierTypeInfos.PROTECTED);
    }

    @Override
    public boolean isApplicableForCheckType(Visibility.CheckType checkType) {
        return checkType == Visibility.CheckType.CALLER_WRITE;
    }

    @Override
    public boolean isApplicableForDefiningTypeVersion(Version propertyDefiningVersion) {
        return true;
    }

    @Override
    public boolean isApplicableForReferencingTypeVersion(Version referencingVersion) {
        return referencingVersion.isLessThan(Version.V182);
    }

    @Override
    public boolean isVisibleThroughLoophole(AccessEvaluator accessEvaluator, Variable property, AstNode referencingNode, Visibility.ReferencedFromTestMethod referencedFromTestMethod) {
        if (!TypeInfoUtil.isAncestor(referencingNode.getDefiningType(), property.getDefiningType())) {
            return false;
        }
        if (!ParentSetterVisible.isGlobalOrPublicOrProtected(property.getModifiers())) {
            return false;
        }
        ModifierGroup getterModifiers = property.accept(Visibility.GET_VARIABLE_MODIFIERS, Visibility.CheckType.CALLER_READ);
        if (getterModifiers.has(ModifierTypeInfos.HIDDEN)) {
            return false;
        }
        if (!ParentSetterVisible.isGlobalOrPublicOrProtected(getterModifiers)) {
            return false;
        }
        ModifierGroup setterModifiers = property.accept(Visibility.GET_VARIABLE_MODIFIERS, Visibility.CheckType.CALLER_WRITE);
        return !setterModifiers.has(ModifierTypeInfos.HIDDEN);
    }
}

