/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.DataCategory;
import apex.jorje.data.soql.DataCategoryOperator;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.soql.FieldIdentifierPrinter;
import com.google.common.collect.Ordering;
import java.util.List;

public class DataCategoryPrinter
implements Printer<DataCategory> {
    private static final Printer<DataCategory> INSTANCE = new DataCategoryPrinter(FieldIdentifierPrinter.get());
    private static final DataCategoryOperator.MatchBlock<String> OP_PRINTER = new DataCategoryOperator.MatchBlock<String>(){

        @Override
        public String _case(DataCategoryOperator.DataCategoryAt x) {
            return "AT";
        }

        @Override
        public String _case(DataCategoryOperator.DataCategoryAbove x) {
            return "ABOVE";
        }

        @Override
        public String _case(DataCategoryOperator.DataCategoryBelow x) {
            return "BELOW";
        }

        @Override
        public String _case(DataCategoryOperator.DataCategoryAboveOrBelow x) {
            return "ABOVE_OR_BELOW";
        }
    };
    private final Printer<FieldIdentifier> fieldIdentifierPrinter;
    private final Printer<List<FieldIdentifier>> listFieldIdentifier;
    private final Ordering<FieldIdentifier> ordering;

    private DataCategoryPrinter(final Printer<FieldIdentifier> fieldIdentifierPrinter) {
        this.fieldIdentifierPrinter = fieldIdentifierPrinter;
        this.listFieldIdentifier = ListPrinter.create(fieldIdentifierPrinter, ", ", "(", ")");
        this.ordering = new Ordering<FieldIdentifier>(){

            @Override
            public int compare(FieldIdentifier left, FieldIdentifier right) {
                return fieldIdentifierPrinter.print(left, PrintContexts.empty()).compareTo(fieldIdentifierPrinter.print(right, PrintContexts.empty()));
            }
        };
    }

    public static Printer<DataCategory> get() {
        return INSTANCE;
    }

    @Override
    public String print(DataCategory x, PrintContext ctx) {
        String op = x.op.match(OP_PRINTER);
        return this.fieldIdentifierPrinter.print(x.type, ctx) + " " + op + " " + this.listFieldIdentifier.print(this.ordering.immutableSortedCopy(x.categories), ctx);
    }
}

