/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.multifile;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.apex.ast.ApexQualifiedName;
import net.sourceforge.pmd.lang.apex.metrics.ApexSignatureMatcher;
import net.sourceforge.pmd.lang.apex.metrics.signature.ApexOperationSigMask;
import net.sourceforge.pmd.lang.apex.multifile.ApexClassStats;

final class ApexProjectMirror
implements ApexSignatureMatcher {
    static final ApexProjectMirror INSTANCE = new ApexProjectMirror();
    private final Map<ApexQualifiedName, ApexClassStats> classes = new HashMap<ApexQualifiedName, ApexClassStats>();

    private ApexProjectMirror() {
    }

    void reset() {
        this.classes.clear();
    }

    ApexClassStats getClassStats(ApexQualifiedName qname, boolean createIfNotFound) {
        ApexQualifiedName className = qname.getClassName();
        if (createIfNotFound && !this.classes.containsKey(className)) {
            this.classes.put(className, new ApexClassStats());
        }
        return this.classes.get(className);
    }

    @Override
    public boolean hasMatchingSig(ApexQualifiedName qname, ApexOperationSigMask mask) {
        ApexClassStats classStats = this.getClassStats(qname, false);
        return classStats != null && classStats.hasMatchingSig(qname.getOperation(), mask);
    }
}

