/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlDeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlInsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlMergeStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUndeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpdateStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTNewKeyValueObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTReferenceExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoslExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;

@InternalApi
public final class Helper {
    public static final String ANY_METHOD = "*";
    private static final String DATABASE_CLASS_NAME = "Database";

    private Helper() {
        throw new AssertionError((Object)"Can't instantiate helper classes");
    }

    public static boolean isTestMethodOrClass(ApexNode<?> node) {
        List modifierNode = node.findChildrenOfType(ASTModifierNode.class);
        for (ASTModifierNode m : modifierNode) {
            if (!m.isTest()) continue;
            return true;
        }
        String className = node.getDefiningType();
        return className.endsWith("Test");
    }

    public static boolean foundAnySOQLorSOSL(ApexNode<?> node) {
        List dmlSoqlExpression = node.findDescendantsOfType(ASTSoqlExpression.class);
        List dmlSoslExpression = node.findDescendantsOfType(ASTSoslExpression.class);
        return !dmlSoqlExpression.isEmpty() || !dmlSoslExpression.isEmpty();
    }

    public static boolean foundAnyDML(ApexNode<?> node) {
        List dmlUpsertStatement = node.findDescendantsOfType(ASTDmlUpsertStatement.class);
        List dmlUpdateStatement = node.findDescendantsOfType(ASTDmlUpdateStatement.class);
        List dmlUndeleteStatement = node.findDescendantsOfType(ASTDmlUndeleteStatement.class);
        List dmlMergeStatement = node.findDescendantsOfType(ASTDmlMergeStatement.class);
        List dmlInsertStatement = node.findDescendantsOfType(ASTDmlInsertStatement.class);
        List dmlDeleteStatement = node.findDescendantsOfType(ASTDmlDeleteStatement.class);
        return !dmlUpsertStatement.isEmpty() || !dmlUpdateStatement.isEmpty() || !dmlUndeleteStatement.isEmpty() || !dmlMergeStatement.isEmpty() || !dmlInsertStatement.isEmpty() || !dmlDeleteStatement.isEmpty();
    }

    public static boolean isMethodName(ASTMethodCallExpression methodNode, String className, String methodName) {
        ASTReferenceExpression reference = (ASTReferenceExpression)methodNode.getFirstChildOfType(ASTReferenceExpression.class);
        return reference != null && reference.getNames().size() == 1 && reference.getNames().get(0).equalsIgnoreCase(className) && (methodName.equals(ANY_METHOD) || Helper.isMethodName(methodNode, methodName));
    }

    public static boolean isMethodName(ASTMethodCallExpression m, String methodName) {
        return m.getMethodName().equalsIgnoreCase(methodName);
    }

    public static boolean isMethodCallChain(ASTMethodCallExpression methodNode, String ... methodNames) {
        ASTReferenceExpression reference;
        String methodName = methodNames[methodNames.length - 1];
        if (Helper.isMethodName(methodNode, methodName) && (reference = (ASTReferenceExpression)methodNode.getFirstChildOfType(ASTReferenceExpression.class)) != null) {
            ASTMethodCallExpression nestedMethod = (ASTMethodCallExpression)reference.getFirstChildOfType(ASTMethodCallExpression.class);
            if (nestedMethod != null) {
                String[] newMethodNames = Arrays.copyOf(methodNames, methodNames.length - 1);
                return Helper.isMethodCallChain(nestedMethod, newMethodNames);
            }
            String[] newClassName = Arrays.copyOf(methodNames, methodNames.length - 1);
            if (newClassName.length == 1) {
                return Helper.isMethodName(methodNode, newClassName[0], methodName);
            }
        }
        return false;
    }

    public static String getFQVariableName(ASTVariableExpression variable) {
        ASTReferenceExpression ref = (ASTReferenceExpression)variable.getFirstChildOfType(ASTReferenceExpression.class);
        String objectName = "";
        if (ref != null && ref.getNames().size() == 1) {
            objectName = ref.getNames().get(0) + ".";
        }
        StringBuilder sb = new StringBuilder().append(variable.getDefiningType()).append(":").append(objectName).append(variable.getImage());
        return sb.toString();
    }

    public static String getFQVariableName(ASTVariableDeclaration variable) {
        StringBuilder sb = new StringBuilder().append(variable.getDefiningType()).append(":").append(variable.getImage());
        return sb.toString();
    }

    public static String getFQVariableName(ASTField variable) {
        StringBuilder sb = new StringBuilder().append(variable.getDefiningType()).append(":").append(variable.getName());
        return sb.toString();
    }

    static String getVariableType(ASTField variable) {
        StringBuilder sb = new StringBuilder().append(variable.getDefiningType()).append(":").append(variable.getName());
        return sb.toString();
    }

    public static String getFQVariableName(ASTFieldDeclaration variable) {
        StringBuilder sb = new StringBuilder().append(variable.getDefiningType()).append(":").append(variable.getImage());
        return sb.toString();
    }

    public static String getFQVariableName(ASTNewKeyValueObjectExpression variable) {
        StringBuilder sb = new StringBuilder().append(variable.getDefiningType()).append(":").append(variable.getType());
        return sb.toString();
    }

    public static boolean isSystemLevelClass(ASTUserClass node) {
        List<String> interfaces = node.getInterfaceNames();
        return interfaces.stream().anyMatch(Helper::isAllowed);
    }

    private static boolean isAllowed(String identifier) {
        switch (identifier.toLowerCase(Locale.ROOT)) {
            case "queueable": 
            case "database.batchable": 
            case "installhandler": {
                return true;
            }
        }
        return false;
    }

    public static String getFQVariableName(ASTParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append(p.getDefiningType()).append(":").append(p.getImage());
        return sb.toString();
    }

    public static boolean isAnyDatabaseMethodCall(ASTMethodCallExpression node) {
        return Helper.isMethodName(node, DATABASE_CLASS_NAME, ANY_METHOD);
    }
}

