/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.StringReader;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.internal.JavaCCTokenizer;
import net.sourceforge.pmd.cpd.token.JavaCCTokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.modelica.ModelicaTokenManager;
import net.sourceforge.pmd.lang.modelica.ast.Token;

public class ModelicaTokenizer
extends JavaCCTokenizer {
    protected TokenManager getLexerForSource(SourceCode sourceCode) {
        StringBuilder stringBuilder = sourceCode.getCodeBuffer();
        return new ModelicaTokenManager(new StringReader(stringBuilder.toString()));
    }

    protected JavaCCTokenFilter getTokenFilter(TokenManager tokenManager) {
        return new ModelicaTokenFilter(tokenManager);
    }

    public static class ModelicaTokenFilter
    extends JavaCCTokenFilter {
        private boolean discardingWithinAndImport = false;
        private boolean discardingAnnotation = false;

        ModelicaTokenFilter(TokenManager tokenManager) {
            super(tokenManager);
        }

        private void skipWithinAndImport(Token currentToken) {
            int type = currentToken.kind;
            if (type == 13 || type == 14) {
                this.discardingWithinAndImport = true;
            } else if (this.discardingWithinAndImport && type == 8) {
                this.discardingWithinAndImport = false;
            }
        }

        private void skipAnnotation(Token currentToken) {
            int type = currentToken.kind;
            if (type == 56) {
                this.discardingAnnotation = true;
            } else if (this.discardingAnnotation && type == 8) {
                this.discardingAnnotation = false;
            }
        }

        protected void analyzeToken(GenericToken currentToken) {
            this.skipWithinAndImport((Token)currentToken);
            this.skipAnnotation((Token)currentToken);
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingWithinAndImport || this.discardingAnnotation;
        }
    }
}

