/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleChainVisitor;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;

@Deprecated
public abstract class AbstractRuleChainVisitor
implements RuleChainVisitor {
    private static final Logger LOG = Logger.getLogger(AbstractRuleChainVisitor.class.getName());
    protected Map<RuleSet, List<Rule>> ruleSetRules = new LinkedHashMap<RuleSet, List<Rule>>();
    protected Map<String, List<Node>> nodeNameToNodes;

    @Override
    public void add(RuleSet ruleSet, Rule rule) {
        if (!this.ruleSetRules.containsKey(ruleSet)) {
            this.ruleSetRules.put(ruleSet, new ArrayList());
        }
        this.ruleSetRules.get(ruleSet).add(rule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitAll(List<Node> nodes, RuleContext ctx) {
        this.initialize();
        this.clear();
        try (TimedOperation to = TimeTracker.startOperation(TimedOperationCategory.RULECHAIN_VISIT);){
            this.indexNodes(nodes, ctx);
        }
        to = TimeTracker.startOperation(TimedOperationCategory.RULECHAIN_RULE);
        try {
            for (Map.Entry<RuleSet, List<Rule>> entry : this.ruleSetRules.entrySet()) {
                RuleSet ruleSet = entry.getKey();
                if (!ruleSet.applies(ctx.getSourceCodeFile())) continue;
                for (Rule rule : entry.getValue()) {
                    int visits = 0;
                    if (!RuleSet.applies(rule, ctx.getLanguageVersion())) continue;
                    try {
                        TimedOperation rcto = TimeTracker.startOperation(TimedOperationCategory.RULECHAIN_RULE, rule.getName());
                        try {
                            List<String> nodeNames = rule.getRuleChainVisits();
                            for (int j = 0; j < nodeNames.size(); ++j) {
                                List<Node> ns = this.nodeNameToNodes.get(nodeNames.get(j));
                                for (Node node : ns) {
                                    Rule actualRule = rule;
                                    while (actualRule instanceof RuleReference) {
                                        actualRule = ((RuleReference)actualRule).getRule();
                                    }
                                    this.visit(actualRule, node, ctx);
                                }
                                visits += ns.size();
                            }
                            rcto.close(visits);
                        }
                        finally {
                            if (rcto == null) continue;
                            rcto.close();
                        }
                    }
                    catch (RuntimeException e) {
                        if (!ctx.isIgnoreExceptions()) throw e;
                        ctx.getReport().addError(new Report.ProcessingError(e, String.valueOf(ctx.getSourceCodeFile())));
                        if (!LOG.isLoggable(Level.WARNING)) continue;
                        LOG.log(Level.WARNING, "Exception applying rule " + rule.getName() + " on file " + ctx.getSourceCodeFile() + ", continuing with next rule", e);
                    }
                }
                continue;
                return;
            }
        }
        finally {
            if (to != null) {
                to.close();
            }
        }
    }

    protected abstract void visit(Rule var1, Node var2, RuleContext var3);

    protected abstract void indexNodes(List<Node> var1, RuleContext var2);

    protected void indexNode(Node node) {
        List<Node> nodes = this.nodeNameToNodes.get(node.getXPathNodeName());
        if (nodes != null) {
            nodes.add(node);
        }
    }

    protected void initialize() {
        if (this.nodeNameToNodes != null) {
            return;
        }
        HashSet<String> visitedNodes = new HashSet<String>();
        Iterator<Map.Entry<RuleSet, List<Rule>>> entryIterator = this.ruleSetRules.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<RuleSet, List<Rule>> entry = entryIterator.next();
            Iterator<Rule> ruleIterator = entry.getValue().iterator();
            while (ruleIterator.hasNext()) {
                Rule rule = ruleIterator.next();
                if (rule.isRuleChain()) {
                    visitedNodes.addAll(rule.getRuleChainVisits());
                    this.logXPathRuleChainUsage(true, rule);
                    continue;
                }
                ruleIterator.remove();
                this.logXPathRuleChainUsage(false, rule);
            }
            if (!entry.getValue().isEmpty()) continue;
            entryIterator.remove();
        }
        this.nodeNameToNodes = new HashMap<String, List<Node>>();
        for (String s : visitedNodes) {
            ArrayList nodes = new ArrayList(100);
            this.nodeNameToNodes.put(s, nodes);
        }
    }

    private void logXPathRuleChainUsage(boolean usesRuleChain, Rule rule) {
        Rule r;
        if (LOG.isLoggable(Level.FINE) && (r = rule instanceof RuleReference ? ((RuleReference)rule).getRule() : rule) instanceof XPathRule) {
            String message = (usesRuleChain ? "Using " : "no ") + "rule chain for XPath " + rule.getProperty(XPathRule.VERSION_DESCRIPTOR) + " rule: " + rule.getName() + " (" + rule.getRuleSetName() + ")";
            LOG.fine(message);
        }
    }

    protected void clear() {
        for (List<Node> l : this.nodeNameToNodes.values()) {
            l.clear();
        }
    }
}

