/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.internal.util.ShortFilenameUtil;
import net.sourceforge.pmd.properties.AbstractPropertySource;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.IOUtil;
import org.apache.commons.io.IOUtils;

public abstract class AbstractRenderer
extends AbstractPropertySource
implements Renderer {
    protected String name;
    protected String description;
    protected boolean showSuppressedViolations = true;
    protected Writer writer;
    protected List<String> inputPathPrefixes = Collections.emptyList();

    public AbstractRenderer(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    protected String getPropertySourceType() {
        return "renderer";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isShowSuppressedViolations() {
        return this.showSuppressedViolations;
    }

    @Override
    public void setShowSuppressedViolations(boolean showSuppressedViolations) {
        this.showSuppressedViolations = showSuppressedViolations;
    }

    @Override
    public void setUseShortNames(List<String> inputPaths) {
        this.inputPathPrefixes = inputPaths;
    }

    protected String determineFileName(String inputFileName) {
        return ShortFilenameUtil.determineFileName(this.inputPathPrefixes, inputFileName);
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((Writer)this.writer);
        }
    }

    @Override
    @Experimental
    public void setReportFile(String reportFilename) {
        this.setWriter(IOUtil.createWriter(reportFilename));
    }
}

