/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.util.Locale;
import java.util.logging.Logger;

public class SourceObject {
    private static final String CLASS_NAME = SourceObject.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    String schema;
    String name;
    String type;
    String revision;

    SourceObject(String schema, String type, String name, String revision) {
        this.schema = schema;
        this.type = type;
        this.name = name;
        this.revision = revision;
    }

    public String toString() {
        return String.format("schema=\"%s\",type=\"%s\",name=\"%s\",revision=\"%s\"", this.getSchema(), this.getType(), this.getName(), this.getRevision());
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getSuffixFromType() {
        LOG.entering(CLASS_NAME, "getSuffixFromType", this);
        if (null == this.type || this.type.isEmpty()) {
            return "";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("JAVA")) {
            return ".java";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("TRIGGER")) {
            return ".trg";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("FUNCTION")) {
            return ".fnc";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("PROCEDURE")) {
            return ".prc";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("PACKAGE_BODY")) {
            return ".pkb";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("PACKAGE")) {
            return ".pks";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("TYPE_BODY")) {
            return ".tpb";
        }
        if (this.type.toUpperCase(Locale.ROOT).contains("TYPE")) {
            return ".tps";
        }
        return "";
    }

    public String getPseudoFileName() {
        return String.format("/Database/%s/%s/%s%s", this.getSchema(), this.getType(), this.getName(), this.getSuffixFromType());
    }
}

