/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRules;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ReadOnlyContextRule
implements AnnotationContextRule {
    private static final ReadOnlyContextRule INSTANCE = new ReadOnlyContextRule();
    private static final List<ModifierOrAnnotationTypeInfo> APPLICABLE_MODIFIERS_HTTP = ImmutableList.of(AnnotationTypeInfos.HTTP_GET, AnnotationTypeInfos.HTTP_POST, AnnotationTypeInfos.HTTP_PATCH, AnnotationTypeInfos.HTTP_PUT, AnnotationTypeInfos.HTTP_DELETE);
    private static final List<ModifierOrAnnotationTypeInfo> APPLICABLE_MODIFIERS_UP_TO_224 = ImmutableList.of(ModifierTypeInfos.WEB_SERVICE, AnnotationTypeInfos.REMOTE_ACTION);
    private static final List<ModifierOrAnnotationTypeInfo> APPLICABLE_MODIFIERS_POST_224 = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(APPLICABLE_MODIFIERS_UP_TO_224)).addAll(APPLICABLE_MODIFIERS_HTTP)).build();
    public static String USE_REPLICA_PREFERRED = "preferred";

    private ReadOnlyContextRule() {
    }

    public static ReadOnlyContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        AnnotationParameter parameter = context.getModifiers().get(AnnotationTypeInfos.READ_ONLY).getParameter("useReplica");
        if (parameter != null && USE_REPLICA_PREFERRED.equalsIgnoreCase(parameter.getStringValue())) {
            if (!context.getSymbols().getAccessEvaluator().hasPermission(PlaceholderOrgPerm.APEX_REST_ROCS)) {
                context.addError(I18nSupport.getLabel("annotation.property.invalid.perm.value", "useReplica", AnnotationTypeInfos.READ_ONLY.getApexName(), USE_REPLICA_PREFERRED));
                return;
            }
            if (context.getModifiers().all().stream().noneMatch(APPLICABLE_MODIFIERS_HTTP::contains)) {
                context.addError(I18nSupport.getLabel("annotation.property.value.is.not.allowed", USE_REPLICA_PREFERRED, "useReplica", AnnotationTypeInfos.READ_ONLY.getApexName(), context.getMethodInfo().getName()));
                return;
            }
        }
        if (context.getModifiers().has(ModifierTypeInfos.STATIC)) {
            List<ModifierOrAnnotationTypeInfo> applicableModifiers = context.getVersion().isLessThanOrEqual(Version.V224) ? APPLICABLE_MODIFIERS_UP_TO_224 : APPLICABLE_MODIFIERS_POST_224;
            AnnotationRules.requiredAnyModifier(applicableModifiers.toArray(new ModifierOrAnnotationTypeInfo[0])).validate(context, context.getModifiers(), AnnotationTypeInfos.READ_ONLY.getApexName());
            return;
        }
        TypeInfo schedulable = context.getSymbols().lookupTypeInfo(context.getDefiningType(), InternalTypeInfos.SYSTEM_SCHEDULABLE);
        TypeInfo schedulableContext = context.getSymbols().lookupTypeInfo(context.getDefiningType(), InternalTypeInfos.SYSTEM_SCHEDULABLE_CONTEXT);
        if (!(context.getMethodInfo().getName().equalsIgnoreCase("execute") && context.getMethodInfo().getParameters().size() == 1 && Distance.get().canAssign(context.getDefiningType(), context.getDefiningType(), schedulable) && TypeInfoEquivalence.isEquivalent(MoreIterables.getOnlyElement(context.getMethodInfo().getParameterTypes()), schedulableContext))) {
            context.addNodeError(I18nSupport.getLabel("invalid.read.only"));
        }
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }
}

