/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.GroupByClause;
import apex.jorje.data.soql.GroupByType;
import apex.jorje.data.soql.HavingClause;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.ast.OptionalPrinter;
import apex.jorje.services.printers.soql.FieldPrinter;
import apex.jorje.services.printers.soql.HavingPrinter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class GroupByPrinter
implements Printer<GroupByClause> {
    private static final Printer<GroupByClause> INSTANCE = new GroupByPrinter(HavingPrinter.get(), FieldPrinter.get());
    private static final GroupByType.MatchBlock<String> GROUP_BY_TYPE = new GroupByType.MatchBlock<String>(){

        @Override
        public String _case(GroupByType.GroupByRollUp x) {
            return "ROLLUP(%s)";
        }

        @Override
        public String _case(GroupByType.GroupByCube x) {
            return "CUBE(%s)";
        }
    };
    private final Printer<Optional<HavingClause>> optionalHaving;
    private final Printer<List<Field>> listFieldPrinter;

    private GroupByPrinter(Printer<HavingClause> havingPrinter, Printer<Field> fieldPrinter) {
        this.optionalHaving = OptionalPrinter.create(havingPrinter, "", " ", "");
        this.listFieldPrinter = ListPrinter.create(fieldPrinter, ", ", "", "");
    }

    public static Printer<GroupByClause> get() {
        return INSTANCE;
    }

    @Override
    public String print(GroupByClause x, PrintContext ctx) {
        String typeTemplate = x.type.map(value -> value.match(GROUP_BY_TYPE)).orElse("%s");
        ctx.checkAggregate(true);
        return "GROUP BY " + String.format(typeTemplate, this.listFieldPrinter.print(x.exprs.stream().map(input -> input.field).collect(Collectors.toList()), ctx)) + this.optionalHaving.print(x.having, ctx);
    }
}

