/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserEnum;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.rule.design.AbstractNcssCountRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public class NcssTypeCountRule
extends AbstractNcssCountRule {
    public NcssTypeCountRule() {
        super(ASTUserClass.class);
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 500.0);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 250);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (!node.hasDescendantOfAnyType(new Class[]{ASTUserClass.class})) {
            return super.visit(node, data);
        }
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        if (!node.hasDescendantOfAnyType(new Class[]{ASTUserClass.class})) {
            return super.visit(node, data);
        }
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTUserEnum node, Object data) {
        return this.countNodeChildren(node, data);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!node.getImage().matches("<clinit>|<init>|clone")) {
            return this.countNodeChildren(node, data);
        }
        return NumericConstants.ZERO;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        return NumericConstants.ONE;
    }

    @Override
    public Object[] getViolationParameters(DataPoint point) {
        return new String[]{String.valueOf((int)point.getScore())};
    }
}

