/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.services.DocumentationService;
import apex.jorje.lsp.impl.completions.CompletionItemBuilder;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.services.StandardDocumentationService;
import apex.jorje.lsp.impl.utils.NamesCompletionStrategies;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CompletionItemTransformer {
    public static final String LOCALS_SORT_PREFIX = "03/";
    static final String FIELDS_SORT_PREFIX = "04/";
    static final String METHODS_SORT_PREFIX = "05/";
    static final String SYSTEM_FIELDS_SORT_PREFIX = "06/";
    static final String SYSTEM_METHODS_SORT_PREFIX = "07/";
    static final String SYSTEM_TYPE_SORT_PREFIX = "08/";
    static final String NAMESPACE_SORT_PREFIX = "09/";
    static final String KEYWORD_SORT_PREFIX = "10/";
    static final String OPERATOR_SORT_PREFIX = "11/";

    static List<CompletionItem> transformNamespaces(List<String> namespaces) {
        return namespaces.stream().map(namespace -> new CompletionItemBuilder((String)namespace).kind(CompletionItemKind.Module).insertText((String)namespace).sortText(NAMESPACE_SORT_PREFIX + namespace).documentation("").build()).collect(Collectors.toList());
    }

    public static List<CompletionItem> transformTriggerVariables(List<String> fields) {
        return fields.stream().map(field -> new CompletionItemBuilder((String)field).kind(CompletionItemKind.Field).insertText((String)field).sortText(FIELDS_SORT_PREFIX + field).build()).collect(Collectors.toList());
    }

    public static List<CompletionItem> transform(String prefix, List<ApexTypeId> typeIds) {
        return typeIds.stream().map(t -> CompletionItemTransformer.transform(prefix, t)).collect(Collectors.toList());
    }

    private static CompletionItem transform(String prefix, ApexTypeId typeId) {
        String label = typeId.getApexName().getString().replaceFirst("^System\\.", "");
        int memberIndex = prefix.replaceFirst("^System\\.", "").lastIndexOf(".");
        if (memberIndex > 0 && label.length() > memberIndex + 1) {
            label = label.substring(memberIndex + 1);
        }
        return new CompletionItemBuilder(label).kind(CompletionItemKind.Class).insertText(label).sortText(SYSTEM_TYPE_SORT_PREFIX + label).documentation("").build();
    }

    public static List<CompletionItem> transform(TypeInfo typeInfo, TypeInfo referencingType, @Nullable IdentifierContext identifierContext, DocumentationService documentation) {
        ArrayList<CompletionItem> items = Lists.newArrayList();
        if ("System.Page".equals(typeInfo.getApexName())) {
            return items;
        }
        if (identifierContext != null) {
            switch (identifierContext) {
                case OBJECT: {
                    items.addAll(typeInfo.virtualMethods().getInstance().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(m -> CompletionItemTransformer.transform(m, documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
                    break;
                }
                case STATIC: {
                    items.addAll(typeInfo.methods().getStatics().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(m -> CompletionItemTransformer.transform(m, documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
                    break;
                }
                case NONE: {
                    items.addAll(typeInfo.methods().getStatics().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(m -> CompletionItemTransformer.transform(m, documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
                    items.addAll(typeInfo.virtualMethods().getInstance().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(m -> CompletionItemTransformer.transform(m, documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
                }
            }
            switch (identifierContext) {
                case OBJECT: {
                    CompletionItemTransformer.addNonStaticFields(items, typeInfo, referencingType, documentation);
                    break;
                }
                case STATIC: {
                    items.addAll(typeInfo.fields().all().stream().filter(f -> CompletionItemTransformer.isStatic(f)).filter(f -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, f.getDefiningType(), f.getModifiers(), f.getMemberType() == Member.Type.PROPERTY)).map(m -> CompletionItemTransformer.transform(m, documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
                    break;
                }
                case NONE: {
                    items.addAll(typeInfo.fields().all().stream().map(m -> CompletionItemTransformer.transform(m, documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
                }
            }
        }
        return items;
    }

    static CompletionItem transform(FieldInfo f, MarkupContent doc) {
        CompletionItemKind kind = f.getMemberType() == Member.Type.PROPERTY ? CompletionItemKind.Property : CompletionItemKind.Field;
        return CompletionItemTransformer.transform(f, SYSTEM_FIELDS_SORT_PREFIX, kind, doc);
    }

    static CompletionItem transform(FieldInfo f, String systemFieldsSortPrefix, CompletionItemKind kind, MarkupContent doc) {
        String label = f.getName();
        return new CompletionItemBuilder(label).kind(kind).sortText(systemFieldsSortPrefix + label).detail(StandardDocumentationService.getSymbolText((Either<TypeInfo, Member>)Either.forRight((Object)f))).documentation(doc).build();
    }

    static CompletionItem transform(MethodInfo m, MarkupContent doc) {
        return CompletionItemTransformer.transform(m, SYSTEM_METHODS_SORT_PREFIX, doc);
    }

    static CompletionItem transform(MethodInfo m, String systemMethodsSortPrefix, MarkupContent doc) {
        String parameterNames = m.getParameters().stream().map(p -> p.getName().getValue()).collect(Collectors.joining(", "));
        String label = m.getCanonicalName() + "(" + parameterNames + ")";
        String insertTextParams = IntStream.range(0, m.getParameters().size()).mapToObj(i -> "${" + (i + 1) + ":" + m.getParameters().get(i).getName() + "}").collect(Collectors.joining(", "));
        String insertText = m.getCanonicalName() + "(" + insertTextParams + ")";
        return CompletionItemTransformer.transform(m, systemMethodsSortPrefix, label, insertText, doc);
    }

    static CompletionItem transformMethodDeclaration(MethodInfo m, MarkupContent doc) {
        String parameters = m.getParameters().stream().map(p -> p.getType() + " " + p.getName().getValue()).collect(Collectors.joining(", "));
        String label = m.getReturnType().getApexName() + " " + m.getCanonicalName() + "(" + parameters + ")";
        String insertText = m.getReturnType().getApexName() + " " + m.getCanonicalName() + "(" + parameters + ") {${0}}";
        return CompletionItemTransformer.transform(m, METHODS_SORT_PREFIX, label, insertText, doc);
    }

    static CompletionItem transform(MethodInfo m, String systemMethodsSortPrefix, String label, String insertText, MarkupContent doc) {
        return new CompletionItemBuilder(label).kind(CompletionItemKind.Method).sortText(systemMethodsSortPrefix + label).insertText(insertText).insertTextFormat(InsertTextFormat.Snippet).detail(StandardDocumentationService.getSymbolText((Either<TypeInfo, Member>)Either.forRight((Object)m))).documentation(doc).build();
    }

    static CompletionItem transform(LocalInfo l) {
        String label = l.getName();
        return new CompletionItemBuilder(label).kind(CompletionItemKind.Variable).sortText(LOCALS_SORT_PREFIX + label).detail(StandardDocumentationService.getSymbolText((Either<TypeInfo, Member>)Either.forRight((Object)l))).build();
    }

    static List<CompletionItem> dedup(List<CompletionItem> items) {
        return items.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CompletionItem>(Comparator.comparing(CompletionItem::getLabel))), ArrayList::new));
    }

    private static boolean isStatic(FieldInfo fieldInfo) {
        return fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC);
    }

    private static boolean isStatic(MethodInfo methodInfo) {
        return methodInfo.getModifiers().has(ModifierTypeInfos.STATIC);
    }

    private static void addNonStaticFields(List<CompletionItem> items, TypeInfo typeInfo, TypeInfo referencingType, DocumentationService documentation) {
        TypeInfo typeToProcess = typeInfo;
        while (typeToProcess != null) {
            TypeInfo definingType = typeToProcess;
            items.addAll(typeToProcess.fields().all().stream().filter(f -> !CompletionItemTransformer.isStatic(f)).filter(f -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, definingType, f.getModifiers(), f.getMemberType() == Member.Type.PROPERTY)).map(f -> CompletionItemTransformer.transform(f, documentation.getDocumentation((Member)f))).collect(Collectors.toList()));
            typeToProcess = typeToProcess.parents().superType();
        }
    }

    static void addObjectFields(List<CompletionItem> items, TypeInfo typeInfo, Set<String> excludedFields, DocumentationService documentation) {
        items.addAll(typeInfo.fields().all().stream().filter(f -> !CompletionItemTransformer.isStatic(f)).filter(f -> !excludedFields.contains(f.getName())).filter(f -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), typeInfo, typeInfo, f.getModifiers(), f.getMemberType() == Member.Type.PROPERTY)).map(m -> CompletionItemTransformer.transform(m, documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
    }
}

