/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.converter;

import apex.jorje.lsp.impl.index.converter.ParameterConverter;
import apex.jorje.lsp.impl.index.converter.TypeIdConverter;
import apex.jorje.lsp.impl.index.converter.TypeInfoConverter;
import apex.jorje.lsp.impl.index.node.ApexMethod;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.Modifier;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import java.util.List;

public final class MethodConverter {
    private final TypeIdConverter idConverter;
    private final ParameterConverter parameterConverter;

    public MethodConverter(TypeIdConverter idConverter, ParameterConverter parameterConverter) {
        this.idConverter = idConverter;
        this.parameterConverter = parameterConverter;
    }

    public void addMethod(MethodInfo methodInfo, ApexType definingType) {
        ApexMethod method = new ApexMethod(definingType, methodInfo.getLoc());
        method.setMethodName(methodInfo.getName());
        List<Modifier> modifiers = methodInfo.getModifiers().copy().getModifiers();
        method.setModifiers(TypeInfoConverter.stringifyModifiers(modifiers));
        for (Parameter parameter : methodInfo.getParameters()) {
            this.parameterConverter.addParameter(parameter, method);
        }
        if (methodInfo.isConstructor()) {
            method.setIsConstructor();
        }
        if (methodInfo.getModifiers().isTest()) {
            method.setIsTest();
        }
        ApexTypeId returnType = this.idConverter.getOrCreateTypeId(methodInfo.getReturnType());
        method.setReturnType(returnType);
    }
}

