/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import com.google.common.collect.MoreLists;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsType
extends TypeSafeDiagnosingMatcher<TypeInfo> {
    private final TypeInfo expected;

    private IsType(TypeInfo expected) {
        this.expected = expected;
    }

    public static Matcher<TypeInfo> isType(TypeInfo expected) {
        return new IsType(expected);
    }

    public static Matcher<TypeInfo> isTypeOrNull(TypeInfo expected) {
        return expected == null ? Matchers.nullValue(TypeInfo.class) : new IsType(expected);
    }

    public static Matcher<Iterable<? extends TypeInfo>> containsTypes(TypeInfo ... expected) {
        return expected.length == 0 ? Matchers.emptyIterable() : Matchers.contains(Arrays.stream(expected).map(IsType::isType).collect(MoreLists.toImmutableList(expected.length)));
    }

    protected boolean matchesSafely(TypeInfo type, Description description) {
        if (type.isResolved()) {
            description.appendText("but found (" + type.getClass().getSimpleName() + ") " + type);
        } else {
            description.appendText("but found an unresolved type");
        }
        return TypeInfoEquivalence.isEquivalent(this.expected, type);
    }

    public void describeTo(Description description) {
        description.appendText("a type equivalent to (" + this.expected.getClass().getSimpleName() + ") " + this.expected);
    }
}

