/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.Identifier;
import apex.jorje.data.soql.DistanceFunctionExpr;
import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.Query;
import apex.jorje.data.soql.SelectExpr;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.ast.IdentifierPrinter;
import apex.jorje.services.printers.ast.OptionalPrinter;
import apex.jorje.services.printers.soql.CaseExprPrinter;
import apex.jorje.services.printers.soql.DistanceFunctionExprPrinter;
import apex.jorje.services.printers.soql.FieldPrinter;
import apex.jorje.services.printers.soql.QueryPrinter;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;

public class SelectExprPrinter
implements Printer<SelectExpr> {
    private static final Printer<SelectExpr> INSTANCE = new SelectExprPrinter(QueryPrinter.get(), IdentifierPrinter.get(), FieldPrinter.get(), DistanceFunctionExprPrinter.get());
    private static final Set<String> AGGREGATE_FUNCTIONS = Sets.newHashSet("AVG", "COUNT", "COUNT_DISTINCT", "MIN", "MAX", "SUM");
    private final Supplier<Printer<Query>> queryPrinter;
    private final Printer<Field> fieldPrinter;
    private final Printer<DistanceFunctionExpr> distanceFunctionExprPrinter;
    private final Printer<Optional<Identifier>> optionalAlias;

    private SelectExprPrinter(Supplier<Printer<Query>> queryPrinter, Printer<Identifier> identifierPrinter, Printer<Field> fieldPrinter, Printer<DistanceFunctionExpr> distanceFunctionExprPrinter) {
        this.queryPrinter = queryPrinter;
        this.fieldPrinter = fieldPrinter;
        this.distanceFunctionExprPrinter = distanceFunctionExprPrinter;
        this.optionalAlias = OptionalPrinter.create(identifierPrinter, "", " ", "");
    }

    public static Printer<SelectExpr> get() {
        return INSTANCE;
    }

    @Override
    public String print(SelectExpr x, final PrintContext ctx) {
        return x.match(new SelectExpr.MatchBlock<String>(){

            @Override
            public String _case(SelectExpr.SelectCaseExpr x) {
                return CaseExprPrinter.get().print(x.expr, ctx) + SelectExprPrinter.this.optionalAlias.print(x.alias, ctx);
            }

            @Override
            public String _case(SelectExpr.SelectColumnExpr x) {
                ctx.checkAggregate(SelectExprPrinter.this.isAggregate(x.field.function1));
                ctx.checkAggregate(SelectExprPrinter.this.isAggregate(x.field.function2));
                return SelectExprPrinter.this.fieldPrinter.print(x.field, ctx) + SelectExprPrinter.this.optionalAlias.print(x.alias, ctx);
            }

            @Override
            public String _case(SelectExpr.SelectInnerQuery x) {
                return "(" + ((Printer)SelectExprPrinter.this.queryPrinter.get()).print(x.query, ctx) + ")" + SelectExprPrinter.this.optionalAlias.print(x.alias, ctx);
            }

            @Override
            public String _case(SelectExpr.SelectDistanceExpr x) {
                return SelectExprPrinter.this.distanceFunctionExprPrinter.print(x.expr, ctx) + SelectExprPrinter.this.optionalAlias.print(x.alias, ctx);
            }
        });
    }

    private boolean isAggregate(Optional<Identifier> function) {
        return function.map(value -> AGGREGATE_FUNCTIONS.contains(value.getValue().toUpperCase())).orElse(false);
    }
}

