/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

@Deprecated
@InternalApi
public abstract class AbstractJUnitRule
extends AbstractJavaRule {
    protected static final String JUNIT3_CLASS_NAME = "junit.framework.TestCase";
    protected static final String JUNIT4_CLASS_NAME = "org.junit.Test";
    protected static final String JUNIT5_CLASS_NAME = "org.junit.jupiter.api.Test";
    private static final String JUNIT5_NESTED = "org.junit.jupiter.api.Nested";
    private static final Set<String> JUNIT5_TEST_ANNOTATIONS = new HashSet<String>(Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.params.ParameterizedTest"));
    private static final String TESTNG_ANNOTATION = "org.testng.annotations.Test";
    protected boolean isJUnit3Class;
    protected boolean isJUnit4Class;
    protected boolean isJUnit5Class;
    private boolean isTestNgClass;

    public void start(RuleContext ctx) {
        super.start(ctx);
        this.isTestNgClass = false;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        if (node.getImportedName() != null && node.getImportedName().startsWith("org.testng")) {
            this.isTestNgClass = true;
        }
        return super.visit(node, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        boolean oldJUnit3Class = this.isJUnit3Class;
        boolean oldJUnit4Class = this.isJUnit4Class;
        boolean oldJUnit5Class = this.isJUnit5Class;
        try {
            this.analyzeJUnitClass(node);
            super.visit(node, data);
        }
        finally {
            this.isJUnit3Class = oldJUnit3Class;
            this.isJUnit4Class = oldJUnit4Class;
            this.isJUnit5Class = oldJUnit5Class;
        }
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceBodyDeclaration node, Object data) {
        if (node.getFirstChildOfType(ASTMethodDeclaration.class) != null && !this.isJUnitTestClass()) {
            return data;
        }
        return super.visit(node, data);
    }

    protected boolean isJUnitTestClass() {
        return !this.isTestNgClass && (this.isJUnit3Class || this.isJUnit4Class || this.isJUnit5Class);
    }

    protected void analyzeJUnitClass(ASTClassOrInterfaceDeclaration node) {
        this.isJUnit3Class = AbstractJUnitRule.isJUnit3Class(node);
        this.isJUnit4Class = AbstractJUnitRule.isJUnit4Class(node);
        this.isJUnit5Class = AbstractJUnitRule.isJUnit5Class(node);
        if (this.isJUnit4Class && this.isJUnit5Class) {
            this.isJUnit4Class &= AbstractJUnitRule.hasImports((JavaNode)node, JUNIT4_CLASS_NAME);
            this.isJUnit5Class &= AbstractJUnitRule.hasImports((JavaNode)node, JUNIT5_TEST_ANNOTATIONS);
        }
    }

    public static boolean isTestClass(ASTClassOrInterfaceBody node) {
        return !AbstractJUnitRule.isAbstractClass(node) && node.getParent() instanceof ASTClassOrInterfaceDeclaration && (AbstractJUnitRule.isTestClassJUnit3(node) || AbstractJUnitRule.isTestClassJUnit4(node) || AbstractJUnitRule.isTestClassJUnit5(node) || AbstractJUnitRule.isTestClassTestNg(node));
    }

    private static boolean isAbstractClass(ASTClassOrInterfaceBody node) {
        if (node.getParent() instanceof ASTClassOrInterfaceDeclaration) {
            ASTClassOrInterfaceDeclaration decl = (ASTClassOrInterfaceDeclaration)node.getParent();
            return decl.isAbstract();
        }
        return false;
    }

    public static boolean isTestClassJUnit3(ASTClassOrInterfaceBody node) {
        Node parent = node.getParent();
        if (parent instanceof TypeNode) {
            TypeNode type = (TypeNode)parent;
            return AbstractJUnitRule.isJUnit3Class(type);
        }
        return false;
    }

    public static boolean isTestClassJUnit4(ASTClassOrInterfaceBody node) {
        Node parent = node.getParent();
        if (parent instanceof TypeNode) {
            TypeNode type = (TypeNode)parent;
            return AbstractJUnitRule.isJUnit4Class(type) && AbstractJUnitRule.hasImports((JavaNode)type, JUNIT4_CLASS_NAME);
        }
        return false;
    }

    public static boolean isTestClassJUnit5(ASTClassOrInterfaceBody node) {
        Node parent = node.getParent();
        if (parent instanceof TypeNode) {
            TypeNode type = (TypeNode)parent;
            return AbstractJUnitRule.isJUnit5Class(type) && AbstractJUnitRule.hasImports((JavaNode)type, JUNIT5_TEST_ANNOTATIONS);
        }
        return false;
    }

    private static boolean isTestClassTestNg(ASTClassOrInterfaceBody node) {
        Node parent = node.getParent();
        if (parent instanceof TypeNode) {
            TypeNode type = (TypeNode)parent;
            return AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)type, TESTNG_ANNOTATION);
        }
        return false;
    }

    public static boolean isTestMethod(ASTMethodDeclaration method) {
        if (method.isAbstract() || method.isNative() || method.isStatic()) {
            return false;
        }
        ASTClassOrInterfaceBody type = (ASTClassOrInterfaceBody)method.getFirstParentOfType(ASTClassOrInterfaceBody.class);
        return AbstractJUnitRule.isTestClassJUnit3(type) && method.isPublic() && method.isVoid() && method.getName().startsWith("test") || AbstractJUnitRule.isTestClassJUnit4(type) && method.isPublic() && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT4_CLASS_NAME) || AbstractJUnitRule.isTestClassJUnit5(type) && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT5_TEST_ANNOTATIONS) || AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), TESTNG_ANNOTATION);
    }

    public static boolean isJUnit5NestedClass(ASTClassOrInterfaceBody innerClassDecl) {
        return AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)innerClassDecl.getNthParent(2), JUNIT5_NESTED);
    }

    public boolean isJUnitMethod(ASTMethodDeclaration method, Object data) {
        if (method.isAbstract() || method.isNative() || method.isStatic()) {
            return false;
        }
        if (!this.isJUnit5Class && !method.isPublic()) {
            return false;
        }
        boolean result = false;
        result |= this.isJUnit3Method(method);
        result |= this.isJUnit4Method(method);
        return result |= this.isJUnit5Method(method);
    }

    private boolean isJUnit4Method(ASTMethodDeclaration method) {
        return this.isJUnit4Class && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT4_CLASS_NAME);
    }

    private boolean isJUnit5Method(ASTMethodDeclaration method) {
        return this.isJUnit5Class && AbstractJUnitRule.doesNodeContainJUnitAnnotation((JavaNode)method.getParent(), JUNIT5_TEST_ANNOTATIONS);
    }

    private boolean isJUnit3Method(ASTMethodDeclaration method) {
        return this.isJUnit3Class && method.isVoid() && method.getName().startsWith("test");
    }

    private static boolean isJUnit3Class(TypeNode cid) {
        return TypeTestUtil.isA(JUNIT3_CLASS_NAME, cid);
    }

    private static boolean isJUnit4Class(JavaNode node) {
        return AbstractJUnitRule.doesNodeContainJUnitAnnotation(node, JUNIT4_CLASS_NAME);
    }

    private static boolean isJUnit5Class(JavaNode node) {
        return AbstractJUnitRule.doesNodeContainJUnitAnnotation(node, JUNIT5_TEST_ANNOTATIONS);
    }

    private static boolean doesNodeContainJUnitAnnotation(JavaNode node, String annotationTypeClassName) {
        return AbstractJUnitRule.doesNodeContainJUnitAnnotation(node, Collections.singleton(annotationTypeClassName));
    }

    private static boolean doesNodeContainJUnitAnnotation(JavaNode node, Set<String> annotationTypeClassNames) {
        List annotations = node.findDescendantsOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            Node annotationTypeNode = annotation.getChild(0);
            TypeNode annotationType = (TypeNode)annotationTypeNode;
            if (annotationType.getType() == null) {
                ASTName name = (ASTName)annotationTypeNode.getFirstChildOfType(ASTName.class);
                if (name == null) continue;
                for (String annotationTypeName : annotationTypeClassNames) {
                    if (!AbstractJUnitRule.areNamesEqual(name, annotationTypeName)) continue;
                    return true;
                }
                continue;
            }
            for (String annotationTypeClassName : annotationTypeClassNames) {
                if (!TypeTestUtil.isA(annotationTypeClassName, annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasImports(JavaNode node, String className) {
        return AbstractJUnitRule.hasImports(node, Collections.singleton(className));
    }

    private static boolean hasImports(JavaNode node, Set<String> classNames) {
        List imports = node.getRoot().findDescendantsOfType(ASTImportDeclaration.class);
        for (ASTImportDeclaration importDeclaration : imports) {
            ASTName name = (ASTName)importDeclaration.getFirstChildOfType(ASTName.class);
            if (name == null || !classNames.contains(name.getImage())) continue;
            return true;
        }
        return false;
    }

    private static boolean areNamesEqual(ASTName node, String fullyQualifiedAnnotationName) {
        String simpleName = node.getImage();
        if (simpleName.equals(fullyQualifiedAnnotationName)) {
            return true;
        }
        String simpleAnnotationName = fullyQualifiedAnnotationName;
        int lastDot = fullyQualifiedAnnotationName.lastIndexOf(46);
        if (lastDot != -1) {
            simpleAnnotationName = fullyQualifiedAnnotationName.substring(lastDot + 1);
        }
        return simpleName.equals(simpleAnnotationName) && AbstractJUnitRule.hasImports((JavaNode)node, fullyQualifiedAnnotationName);
    }
}

