/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public final class UseTryWithResourcesRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<List<String>> CLOSE_METHODS = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"closeMethods").desc("Method names in finally block, which trigger this rule")).defaultValues((Object)"close", (Object[])new String[]{"closeQuietly"}).delim(',').build();

    public UseTryWithResourcesRule() {
        this.addRuleChainVisit(ASTTryStatement.class);
        this.definePropertyDescriptor(CLOSE_METHODS);
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        boolean isJava9OrLater = this.isJava9OrLater((RuleContext)data);
        ASTFinallyStatement finallyClause = node.getFinallyClause();
        if (finallyClause != null) {
            List<ASTName> methods = this.findCloseMethods(finallyClause.findDescendantsOfType(ASTName.class));
            for (ASTName method : methods) {
                ASTName closeTarget = this.getCloseTarget(method);
                if (!TypeTestUtil.isA(AutoCloseable.class, (TypeNode)closeTarget) || !isJava9OrLater && !this.isLocalVar(closeTarget)) continue;
                this.addViolation(data, (Node)node);
                break;
            }
        }
        return data;
    }

    private boolean isJava9OrLater(RuleContext ruleContext) {
        String currentVersion = ruleContext.getLanguageVersion().getVersion();
        return Double.parseDouble(currentVersion = currentVersion.replace("-preview", "")) >= 9.0;
    }

    private boolean isLocalVar(ASTName closeTarget) {
        NameDeclaration nameDeclaration = closeTarget.getNameDeclaration();
        if (nameDeclaration instanceof VariableNameDeclaration) {
            ASTVariableDeclaratorId id = ((VariableNameDeclaration)nameDeclaration).getDeclaratorId();
            return id.isLocalVariable();
        }
        if (closeTarget.getImage().contains(".")) {
            int lastDot = closeTarget.getImage().lastIndexOf(46);
            String varName = closeTarget.getImage().substring(0, lastDot);
            Map vars = ((MethodScope)closeTarget.getScope().getEnclosingScope(MethodScope.class)).getDeclarations(VariableNameDeclaration.class);
            for (VariableNameDeclaration varDecl : vars.keySet()) {
                if (!varDecl.getName().equals(varName)) continue;
                return varDecl.getDeclaratorId().isLocalVariable();
            }
        }
        return false;
    }

    private ASTName getCloseTarget(ASTName method) {
        ASTName firstArgument;
        ASTArguments arguments = (ASTArguments)method.getNthParent(2).getFirstDescendantOfType(ASTArguments.class);
        if (arguments.size() > 0 && (firstArgument = (ASTName)((JavaNode)arguments.getChild(0)).getChild(0).getFirstDescendantOfType(ASTName.class)) != null) {
            return firstArgument;
        }
        return method;
    }

    private List<ASTName> findCloseMethods(List<ASTName> names) {
        ArrayList<ASTName> potentialCloses = new ArrayList<ASTName>();
        for (ASTName name : names) {
            String image = name.getImage();
            int lastDot = image.lastIndexOf(46);
            if (lastDot > -1) {
                image = image.substring(lastDot + 1);
            }
            if (!((List)this.getProperty(CLOSE_METHODS)).contains(image) || !this.isMethodCall(name)) continue;
            potentialCloses.add(name);
        }
        return potentialCloses;
    }

    private boolean isMethodCall(ASTName potentialMethodCall) {
        return potentialMethodCall.getNthParent(2) instanceof ASTPrimaryExpression && !potentialMethodCall.getNthParent(2).findChildrenOfType(ASTPrimarySuffix.class).isEmpty();
    }
}

