/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class HardCodedCryptoKeyRule
extends AbstractJavaRule {
    private static final Class<?> SECRET_KEY_SPEC = SecretKeySpec.class;
    private final Set<VariableNameDeclaration> checkedVars = new HashSet<VariableNameDeclaration>();

    public HardCodedCryptoKeyRule() {
        this.addRuleChainVisit(ASTAllocationExpression.class);
    }

    public void start(RuleContext ctx) {
        this.checkedVars.clear();
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (TypeTestUtil.isA(SECRET_KEY_SPEC, (TypeNode)node.getFirstChildOfType(ASTClassOrInterfaceType.class))) {
            Node firstArgument = null;
            ASTArguments arguments = (ASTArguments)node.getFirstChildOfType(ASTArguments.class);
            if (arguments.size() > 0) {
                firstArgument = ((ASTArgumentList)arguments.getFirstChildOfType(ASTArgumentList.class)).getChild(0);
            }
            if (firstArgument != null) {
                ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)firstArgument.getFirstDescendantOfType(ASTPrimaryPrefix.class);
                this.validateProperKeyArgument(data, prefix);
            }
        }
        return data;
    }

    private void validateProperKeyArgument(Object data, ASTPrimaryPrefix firstArgumentExpression) {
        ASTLiteral literal;
        ASTArrayInitializer arrayInit;
        if (firstArgumentExpression == null) {
            return;
        }
        ASTName namedVar = (ASTName)firstArgumentExpression.getFirstDescendantOfType(ASTName.class);
        if (namedVar != null && namedVar.getNameDeclaration() instanceof VariableNameDeclaration && !this.checkedVars.contains(namedVar.getNameDeclaration())) {
            VariableNameDeclaration varDecl = (VariableNameDeclaration)namedVar.getNameDeclaration();
            this.checkedVars.add(varDecl);
            ASTVariableInitializer initializer = (ASTVariableInitializer)varDecl.getAccessNodeParent().getFirstDescendantOfType(ASTVariableInitializer.class);
            if (initializer != null) {
                this.validateProperKeyArgument(data, (ASTPrimaryPrefix)initializer.getFirstDescendantOfType(ASTPrimaryPrefix.class));
            }
            List<NameOccurrence> usages = varDecl.getDeclaratorId().getUsages();
            for (NameOccurrence occurrence : usages) {
                ASTStatementExpression parentExpr = (ASTStatementExpression)occurrence.getLocation().getFirstParentOfType(ASTStatementExpression.class);
                if (!this.isAssignment((Node)occurrence.getLocation(), parentExpr)) continue;
                this.validateProperKeyArgument(data, (ASTPrimaryPrefix)((JavaNode)parentExpr.getChild(2)).getFirstDescendantOfType(ASTPrimaryPrefix.class));
            }
        }
        if ((arrayInit = (ASTArrayInitializer)firstArgumentExpression.getFirstDescendantOfType(ASTArrayInitializer.class)) != null) {
            this.addViolation(data, (Node)arrayInit);
        }
        if ((literal = (ASTLiteral)firstArgumentExpression.getFirstDescendantOfType(ASTLiteral.class)) != null && literal.isStringLiteral()) {
            this.addViolation(data, (Node)literal);
        }
    }

    private boolean isAssignment(Node node, ASTStatementExpression statement) {
        return statement != null && statement.getNumChildren() >= 3 && node == ((JavaNode)statement.getChild(0)).getFirstDescendantOfType(ASTName.class) && statement.getChild(1) instanceof ASTAssignmentOperator;
    }
}

