/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions.soql;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionItemBuilder;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.workspace.ServerSetup;
import apex.jorje.semantic.ast.expression.BindExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.compiler.CodeUnit;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedSoqlCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedSoqlCompletionStrategy.class);
    public static final String SOQL_SPECIAL_COMPLETION_ITEM = "_SOQL_";
    private final ApexDocumentService documentService;
    private final ApexCompilerService compilerService;
    private final Provider<ServerSetup> serverSetupProvider;

    @Inject
    public EmbeddedSoqlCompletionStrategy(ApexDocumentService documentService, ApexCompilerService compilerService, Provider<ServerSetup> serverSetupProvider) {
        this.documentService = documentService;
        this.compilerService = compilerService;
        this.serverSetupProvider = serverSetupProvider;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        ArrayList<CompletionItem> items = Lists.newArrayList();
        if (!((ServerSetup)this.serverSetupProvider.get()).isEnableEmbeddedSoqlCompletion()) {
            return items;
        }
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        optDoc.ifPresent(doc -> {
            try {
                int lineOffset = doc.getLineOffset(params.getPosition().getLine());
                int offset = lineOffset + params.getPosition().getCharacter();
                SoqlExpressionVisitor soqlVisitor = new SoqlExpressionVisitor(offset);
                CodeUnit codeUnit = this.compilerService.compile((Document)doc);
                codeUnit.getNode().traverse(soqlVisitor, NoopScope.get());
                if (soqlVisitor.soqlExpressionNode != null) {
                    items.add(this.buildCompletionItem(soqlVisitor.soqlExpressionNode));
                }
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing completion", (Throwable)ble);
            }
        });
        return items;
    }

    private CompletionItem buildCompletionItem(SoqlExpression soqlExpressionNode) {
        CompletionItemBuilder builder = new CompletionItemBuilder(SOQL_SPECIAL_COMPLETION_ITEM);
        builder.kind(CompletionItemKind.Snippet).detail(soqlExpressionNode.getRawQuery()).data(soqlExpressionNode.getLoc());
        return builder.build();
    }

    static final class SoqlExpressionVisitor
    extends AstVisitor<NoopScope> {
        final int activationOffset;
        @Nullable
        public SoqlExpression soqlExpressionNode;

        SoqlExpressionVisitor(int activationOffset) {
            this.activationOffset = activationOffset;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public boolean visit(SoqlExpression node, NoopScope scope) {
            return true;
        }

        @Override
        public void visitEnd(SoqlExpression node, NoopScope scope) {
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (startIndex <= this.activationOffset && this.activationOffset < endIndex) {
                boolean inApexBindingExpression = false;
                for (BindExpression bindExpr : node.getBindExpressions()) {
                    int bindingStartIndex = bindExpr.getExpression().getLoc().getStartIndex();
                    int bindingEndIndex = bindExpr.getExpression().getLoc().getEndIndex();
                    if (bindingStartIndex - 1 > this.activationOffset || this.activationOffset > bindingEndIndex) continue;
                    inApexBindingExpression = this.activationOffset >= bindingStartIndex || node.getQuery().charAt(bindingStartIndex - 1 - node.getLoc().getStartIndex()) == '(';
                    break;
                }
                if (!inApexBindingExpression) {
                    this.soqlExpressionNode = node;
                }
            }
        }
    }
}

