/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import java.util.Collection;

public class LocalNameConflictVisitor
extends AstVisitor<NoopScope> {
    private Statement containingBlock;
    private final String newNameForLocal;
    private boolean conflictingName;

    public LocalNameConflictVisitor(Statement containingBlock, String newNameForLocal) {
        this.containingBlock = containingBlock;
        this.newNameForLocal = newNameForLocal;
        this.conflictingName = false;
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(BlockStatement statement, NoopScope scope) {
        if (!this.conflictingName) {
            super.visitEnd(statement, scope);
            this.checkForNameConflict(statement, statement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(CatchBlockStatement catchStatement, NoopScope scope) {
        if (!this.conflictingName) {
            super.visitEnd(catchStatement, scope);
            this.checkForNameConflict(catchStatement, catchStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(ForEachStatement forEachStatement, NoopScope scope) {
        if (!this.conflictingName) {
            super.visitEnd(forEachStatement, scope);
            this.checkForNameConflict(forEachStatement, forEachStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(ForLoopStatement forLoopStatement, NoopScope scope) {
        if (!this.conflictingName) {
            super.visitEnd(forLoopStatement, scope);
            this.checkForNameConflict(forLoopStatement.getBody(), forLoopStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(IfElseBlockStatement ifElseBlockStatement, NoopScope scope) {
        if (!this.conflictingName) {
            super.visitEnd(ifElseBlockStatement, scope);
            this.checkForNameConflict(ifElseBlockStatement, ifElseBlockStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(TypeWhenBlock typeWhenBlock, NoopScope scope) {
        if (!this.conflictingName) {
            super.visitEnd(typeWhenBlock, scope);
            this.checkForNameConflict(typeWhenBlock.getBlock(), typeWhenBlock.getLocals().all());
        }
    }

    @Override
    public void visitEnd(Method method, NoopScope scope) {
        if (!this.conflictingName) {
            super.visitEnd(method, scope);
            this.checkForNameConflict(method.getBody(), method.getLocals().all());
        }
    }

    private boolean isEnclosingScope(Statement statement) {
        return this.containingBlock.getLoc().getStartIndex() >= statement.getLoc().getStartIndex() && this.containingBlock.getLoc().getEndIndex() <= statement.getLoc().getEndIndex() || this.containingBlock.getLoc().getStartIndex() <= statement.getLoc().getStartIndex() && this.containingBlock.getLoc().getEndIndex() >= statement.getLoc().getEndIndex();
    }

    private void checkForNameConflict(Statement statement, Collection<LocalInfo> locals) {
        if (this.isEnclosingScope(statement)) {
            if (locals.stream().map(LocalInfo::getName).anyMatch(this.newNameForLocal::equalsIgnoreCase)) {
                this.conflictingName = true;
            }
        }
    }

    public boolean hasConflictingName() {
        return this.conflictingName;
    }
}

