/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.Emit;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.member.SystemModeEmit;
import apex.jorje.semantic.ast.modifier.Annotations;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroupBuilder;
import apex.jorje.semantic.ast.statement.ConstructorPreambleStatement;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.bcl.ThrowableEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureFactory;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Label;

public class UserExceptionMethods
implements AstNode {
    public static final String DEFAULT_MESSAGE = "Script-thrown exception";
    private static final Signature NONE = SignatureFactory.create("<init>", TypeInfos.VOID);
    private static final Signature MESSAGE = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, TypeInfos.STRING);
    private static final Signature CAUSE = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, TypeInfos.EXCEPTION);
    private static final Signature MESSAGE_CAUSE = SignatureFactory.create("<init>", (TypeInfo)TypeInfos.VOID, TypeInfos.STRING, TypeInfos.EXCEPTION);
    private static final String EXCEPTION_DETAIL_MESSAGE_FIELD_NAME = "sfdc_detailMessage";
    public static final Emit PUT_DEFAULT_MESSAGE = UserExceptionMethods.createPutMessage(false);
    private static final Emit PUT_MESSAGE = UserExceptionMethods.createPutMessage(true);
    private final TypeInfo parentCauseType;
    private final boolean isApexBaseException;
    private final Location loc;
    private final TypeInfo definingType;
    private List<Method> methods;

    UserExceptionMethods(AstNode node, Location loc) {
        this.definingType = node.getDefiningType();
        this.loc = loc;
        this.isApexBaseException = Objects.equals(InternalTypeInfos.APEX_EXCEPTION.getApexName(), this.definingType.getApexName());
        this.parentCauseType = this.isApexBaseException ? InternalTypeInfos.THROWABLE : TypeInfos.EXCEPTION;
    }

    private static Emit createPutMessage(boolean hasMessage) {
        return emitter -> {
            TypeInfo type = emitter.getType();
            emitter.emitVar(Locations.NONE, 25, 0);
            if (hasMessage) {
                emitter.emitVar(Locations.NONE, 25, 1);
            } else {
                emitter.push(Locations.NONE, DEFAULT_MESSAGE);
            }
            emitter.emitField(Locations.NONE, 181, type.getBytecodeName(), EXCEPTION_DETAIL_MESSAGE_FIELD_NAME, TypeInfos.STRING.getTypeSignature());
        };
    }

    private Statement createStatement(final Emit body, final boolean hasMessage) {
        return new ConstructorPreambleStatement(this, this.loc, Statement.NOOP){

            @Override
            public void emit(Emitter emitter) {
                if (!UserExceptionMethods.this.isApexBaseException) {
                    SystemModeEmit.emitter().withType(UserExceptionMethods.this.definingType).withBody(body).emit(emitter);
                } else {
                    body.emit(emitter);
                }
                super.emit(emitter);
                if (UserExceptionMethods.this.isApexBaseException) {
                    if (hasMessage) {
                        PUT_MESSAGE.emit(emitter);
                    } else {
                        PUT_DEFAULT_MESSAGE.emit(emitter);
                    }
                }
                emitter.emit(Locations.NONE, 177);
            }
        };
    }

    private Method noneConstructor(ModifierGroup modifiers) {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Locations.NONE, 25, 0);
            emitter.push(Locations.NONE, DEFAULT_MESSAGE);
            emitter.emit(Locations.NONE, ObjectEmitMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING));
        }, false);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setName("<init>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method messageConstructor(ModifierGroup modifiers) {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Locations.NONE, 25, 0);
            emitter.emitVar(Locations.NONE, 25, 1);
            emitter.emit(Locations.NONE, ObjectEmitMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING));
        }, true);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setHiddenParameterTypes(TypeInfos.STRING).setName("<init>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method causeConstructor(ModifierGroup modifiers) {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Locations.NONE, 25, 0);
            emitter.push(Locations.NONE, DEFAULT_MESSAGE);
            emitter.emitVar(Locations.NONE, 25, 1);
            emitter.emit(Locations.NONE, ObjectEmitMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING, this.parentCauseType));
        }, false);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setHiddenParameterTypes(TypeInfos.EXCEPTION).setName("<init>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method messageCauseConstructor(ModifierGroup modifiers) {
        Statement root = this.createStatement(emitter -> {
            emitter.emitVar(Locations.NONE, 25, 0);
            emitter.emitVar(Locations.NONE, 25, 1);
            emitter.emitVar(Locations.NONE, 25, 2);
            emitter.emit(Locations.NONE, ObjectEmitMethods.constructor(this.definingType.parents().superType(), TypeInfos.STRING, this.parentCauseType));
        }, true);
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setConstructor().setHiddenParameterTypes(TypeInfos.STRING, TypeInfos.EXCEPTION).setName("<init>").setModifiers(modifiers).setGenerated(Generated.ANONYMOUS_PROXIED), root);
    }

    private Method initCause(ModifierGroup methodModifiers) {
        SimpleStatement root = new SimpleStatement(this, SimpleStatement.Returnable.YES){

            @Override
            public void emit(Emitter emitter) {
                Label branch = new Label();
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emit(Locations.NONE, ThrowableEmitMethods.GET_CAUSE);
                emitter.emitJump(Locations.NONE, 198, branch);
                emitter.emit(Locations.NONE, SystemEmitMethods.THROW_CAUSE_ALREADY_SET);
                emitter.emit(branch);
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emitVar(Locations.NONE, 25, 1);
                emitter.emit(Locations.NONE, ThrowableEmitMethods.INIT_CAUSE);
                emitter.emit(Locations.NONE, 87);
                emitter.emit(Locations.NONE, 177);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setReturnType(TypeInfos.VOID).setParameters(Parameter.builder().setName("cause").setType(TypeInfos.EXCEPTION).setDefiningType(this.definingType).build()).setName("initCause").setModifiers(methodModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method getCause(ModifierGroup methodModifiers) {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emit(Locations.NONE, ThrowableEmitMethods.GET_CAUSE);
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setReturnType(TypeInfos.EXCEPTION).setName("getCause").setModifiers(methodModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method getTypeName(ModifierGroup methodModifiers) {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.push(Locations.NONE, UserExceptionMethods.this.definingType.getApexName());
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.definingType).setReturnType(TypeInfos.STRING).setName("getTypeName").setModifiers(methodModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    public void createMethods(Errors errors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ModifierGroup constructorModifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.GLOBAL).setLoc(this.definingType.getModifiers().getLoc()).build();
        boolean isFileBased = this.definingType.getCodeUnitDetails().isFileBased();
        MethodInfo method = this.definingType.methods().get(NONE);
        if (method == null) {
            builder.add(this.noneConstructor(constructorModifiers));
        } else if (!isFileBased) {
            errors.markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", NONE));
        }
        method = this.definingType.methods().get(MESSAGE);
        if (method == null) {
            builder.add(this.messageConstructor(constructorModifiers));
        } else if (!isFileBased) {
            errors.markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", MESSAGE));
        }
        method = this.definingType.methods().get(CAUSE);
        if (method == null) {
            builder.add(this.causeConstructor(constructorModifiers));
        } else if (!isFileBased) {
            errors.markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", CAUSE));
        }
        method = this.definingType.methods().get(MESSAGE_CAUSE);
        if (method == null) {
            builder.add(this.messageCauseConstructor(constructorModifiers));
        } else if (!isFileBased) {
            errors.markInvalid((AstNode)this, method.getLoc(), I18nSupport.getLabel("invalid.exception.constructor.already.defined", MESSAGE_CAUSE));
        }
        ModifierGroup methodModifiers = this.createMethodModifiers();
        if (this.isApexBaseException) {
            builder.add(new Method[]{this.initCause(methodModifiers), this.getCause(methodModifiers)});
        }
        if (!this.definingType.getCodeUnitDetails().isMocked()) {
            ModifierGroup getTypeNameMethodModifier = this.definingType.getModifiers().has(AnnotationTypeInfos.SFDC_ONLY) ? this.createMethodModifiersForSfdcOnlyType() : methodModifiers;
            builder.add(this.getTypeName(getTypeNameMethodModifier));
        }
        this.methods = builder.build();
    }

    private ModifierGroup createMethodModifiers() {
        ModifierGroupBuilder builder = ModifierGroup.builder().addModifiers(this.definingType.getModifiers().has(ModifierTypeInfos.GLOBAL) ? ModifierTypeInfos.GLOBAL : ModifierTypeInfos.PUBLIC, ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.OVERRIDE, ModifierTypeInfos.VIRTUAL).setLoc(this.definingType.getModifiers().getLoc());
        if (this.isApexBaseException) {
            builder.addAnnotation(Annotations.APEX_SFDC_ONLY_FALSE);
        }
        return builder.build().resolve();
    }

    private ModifierGroup createMethodModifiersForSfdcOnlyType() {
        return this.createMethodModifiers().copy().addAnnotation(Annotations.APEX_SFDC_ONLY_FALSE).setLoc(this.definingType.getModifiers().getLoc()).build().resolve();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope) && this.methods != null) {
            for (Method method : this.methods) {
                method.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (scope.getErrors().isInvalid(this)) {
            return;
        }
        for (Method method : this.methods) {
            method.validate(symbols, scope);
        }
    }

    @Override
    public Location getLoc() {
        throw new UnexpectedCodePathException();
    }

    @VisibleForTesting
    List<Method> getMethods() {
        return this.methods;
    }

    @Override
    public void emit(Emitter emitter) {
        for (Method method : this.methods) {
            method.emit(emitter);
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }
}

