/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;

public class RestResourceContextRule
implements AnnotationContextRule {
    private static final RestResourceContextRule INSTANCE = new RestResourceContextRule();

    private RestResourceContextRule() {
    }

    public static RestResourceContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        this.validateUrl(context);
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(TypeContext context) {
        this.validateUrl(context);
    }

    private void validateUrl(AnnotationContext context) {
        String message;
        AnnotationParameter url = context.getModifiers().get(AnnotationTypeInfos.REST_RESOURCE).getParameter("urlMapping");
        if (url != null && !(message = this.validateUrl(url.getStringValue())).isEmpty()) {
            context.addNodeError(message);
        }
    }

    @VisibleForTesting
    String validateUrl(String url) {
        if (Strings.isNullOrEmpty(url)) {
            return I18nSupport.getLabel("rest.resource.url.empty");
        }
        if (url.length() > 255) {
            return I18nSupport.getLabel("rest.resource.url.too.long");
        }
        if (!url.startsWith("/")) {
            return I18nSupport.getLabel("rest.resource.url.no.slash");
        }
        for (int i = 0; i < url.length(); ++i) {
            char theChar = url.charAt(i);
            if (theChar != '*') continue;
            char prevChar = url.charAt(i - 1);
            if (prevChar != '/') {
                return I18nSupport.getLabel("rest.resource.url.illegal.wildcard.predecessor");
            }
            if (i == url.length() - 1 || url.charAt(i + 1) == '/') continue;
            return I18nSupport.getLabel("rest.resource.url.illegal.wildcard.successor");
        }
        try {
            new URL("http://www.salesforce.com/services/apexrest" + url);
        }
        catch (MalformedURLException x) {
            return I18nSupport.getLabel("rest.resource.url.invalid.url");
        }
        return "";
    }
}

