/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.annotations.VisibleForTesting;

final class IsTestValidation {
    private IsTestValidation() {
    }

    static void validate(TypeContext context, UserClass node) {
        TypeInfo definingType = node.getDefiningType();
        boolean methodHasTestSetup = false;
        boolean methodHasSeeAllData = false;
        for (MethodInfo method : definingType.methods().getStaticsAndInstance()) {
            if (!(methodHasSeeAllData |= IsTestValidation.hasParameter(method.getModifiers(), "seeAllData")) || !(methodHasTestSetup |= method.getModifiers().has(AnnotationTypeInfos.TEST_SETUP))) continue;
            context.addNodeError(I18nSupport.getLabel("test.setup.cannot.have.see.all.data"));
            return;
        }
        boolean classHasSeeAllData = IsTestValidation.definingTypeHasParameter(definingType, "seeAllData");
        boolean classHasIsParallel = IsTestValidation.definingTypeHasParameter(definingType, "isParallel");
        if (classHasSeeAllData && methodHasTestSetup) {
            context.addNodeError(I18nSupport.getLabel("test.setup.cannot.have.defining.type.see.all.data"));
        }
        if (classHasIsParallel && classHasSeeAllData) {
            context.addNodeError(I18nSupport.getLabel("parallel.test.class.cannot.have.see.all.data"));
        }
        if (classHasIsParallel && methodHasSeeAllData) {
            context.addNodeError(I18nSupport.getLabel("parallel.test.method.cannot.have.see.all.data"));
        }
    }

    private static boolean hasParameter(ModifierGroup modifiers, String parameterName) {
        AnnotationParameter isTestParam;
        if (modifiers.has(AnnotationTypeInfos.IS_TEST) && (isTestParam = modifiers.get(AnnotationTypeInfos.IS_TEST).getParameter(parameterName)).getValue() != null) {
            return isTestParam.getBooleanValue();
        }
        return false;
    }

    @VisibleForTesting
    static boolean definingTypeHasParameter(TypeInfo definingType, String parameterName) {
        return IsTestValidation.hasParameter(definingType.getModifiers(), parameterName) || TypeInfoUtil.isInnerType(definingType) && IsTestValidation.hasParameter(TypeInfoUtil.getTopLevel(definingType).getModifiers(), parameterName);
    }
}

