/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.ast.visitor.reference.ReferenceInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class TypedExternalDependency
implements ExternalDependency {
    private final TypeInfo type;
    private final Location loc;
    private final ReferenceInfo referenceInfo;

    private TypedExternalDependency(TypeInfo type, Location loc, ReferenceInfo referenceInfo) {
        this.type = type;
        this.loc = loc;
        this.referenceInfo = referenceInfo;
    }

    public static ExternalDependency create(TypeInfo type, Location loc, ReferenceInfo referenceInfo) {
        return new TypedExternalDependency(type, loc, referenceInfo);
    }

    public TypeInfo getTypeInfo() {
        return this.type;
    }

    public ReferenceInfo getReferenceInfo() {
        return this.referenceInfo;
    }

    public int hashCode() {
        return ObjectHash.hash(this.type, this.loc, this.referenceInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedExternalDependency that = (TypedExternalDependency)o;
        return TypeInfoEquivalence.isEquivalent(this.type, that.type) && Objects.equals(this.loc, that.loc) && Objects.equals(this.referenceInfo, that.referenceInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("loc", this.loc).add("referenceInfo", this.referenceInfo).toString();
    }

    @Override
    public <T> T accept(ExternalDependency.ExternalDependencyVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

