/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.exception;

import apex.jorje.data.Location;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;

public class DependentTypeException
extends CompilationException {
    private static final long serialVersionUID = -8991833610175521515L;
    private final Location loc;
    private final String error;

    private DependentTypeException(Location loc, String error) {
        super(error);
        this.error = error;
        this.loc = loc;
    }

    public static DependentTypeException createDependentTypeException(CompilationException exception, String apexName, boolean useCompactErrorMessages) {
        String errorMessage = useCompactErrorMessages && DependentTypeException.class.isAssignableFrom(exception.getClass()) ? I18nSupport.getLabel("dependent.class.invalidChain", apexName, exception.getError()) : I18nSupport.getLabel("dependent.class.invalid", apexName, exception.getError());
        return new DependentTypeException(exception.getLoc(), errorMessage);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    @Override
    public String getError() {
        return this.error;
    }
}

