/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver;

import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.resolver.TypeRefResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedTypeInfoFactory;
import apex.jorje.semantic.symbol.type.common.GenericTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.services.Version;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;

final class TypeRefResolvers {
    private static final TypeRef.Visitor<TypeRefResolver> GET_RESOLVER = new TypeRef.Visitor<TypeRefResolver>(){

        @Override
        public TypeRefResolver visit(TypeRefs.JavaTypeRef typeRef) {
            return JavaTypeResolver.INSTANCE;
        }

        @Override
        public TypeRefResolver visit(TypeRefs.ClassTypeRef typeRef) {
            return ClassTypeResolver.INSTANCE;
        }

        @Override
        public TypeRefResolver visit(TypeRefs.ArrayTypeRef typeRef) {
            return ArrayTypeResolver.INSTANCE;
        }
    };

    TypeRefResolvers() {
    }

    public static TypeRefResolver get(TypeRef typeRef) {
        return typeRef.accept(GET_RESOLVER);
    }

    private static class ArrayTypeResolver
    implements TypeRefResolver {
        private static final ArrayTypeResolver INSTANCE = new ArrayTypeResolver();

        private ArrayTypeResolver() {
        }

        @Override
        public TypeInfo resolve(SymbolResolver symbols, TypeInfo referencingType, TypeRef typeRef, ReferenceType reference) {
            TypeInfo heldType = symbols.lookupTypeInfo(referencingType, ((TypeRefs.ArrayTypeRef)typeRef).getHeldType(), reference);
            return GenericTypeInfoFactory.createList(symbols, heldType);
        }
    }

    static class ClassTypeResolver
    implements TypeRefResolver {
        private static final ClassTypeResolver INSTANCE = new ClassTypeResolver();

        private ClassTypeResolver() {
        }

        static List<TypeInfo> getTypesFromTypeRefs(SymbolResolver symbols, TypeInfo referencingType, List<TypeRef> typeRefs, ReferenceType reference) {
            switch (typeRefs.size()) {
                case 0: {
                    throw new UnexpectedCodePathException();
                }
                case 1: {
                    return ImmutableList.of(symbols.lookupTypeInfo(referencingType, typeRefs.get(0), reference));
                }
                case 2: {
                    return ImmutableList.of(symbols.lookupTypeInfo(referencingType, typeRefs.get(0), reference), symbols.lookupTypeInfo(referencingType, typeRefs.get(1), reference));
                }
                case 3: {
                    return ImmutableList.of(symbols.lookupTypeInfo(referencingType, typeRefs.get(0), reference), symbols.lookupTypeInfo(referencingType, typeRefs.get(1), reference), symbols.lookupTypeInfo(referencingType, typeRefs.get(2), reference));
                }
                case 4: {
                    return ImmutableList.of(symbols.lookupTypeInfo(referencingType, typeRefs.get(0), reference), symbols.lookupTypeInfo(referencingType, typeRefs.get(1), reference), symbols.lookupTypeInfo(referencingType, typeRefs.get(2), reference), symbols.lookupTypeInfo(referencingType, typeRefs.get(3), reference));
                }
            }
            return typeRefs.stream().map(value -> symbols.lookupTypeInfo(referencingType, (TypeRef)value, reference)).collect(MoreLists.toImmutableList(typeRefs.size()));
        }

        @Override
        public TypeInfo resolve(SymbolResolver symbols, TypeInfo referencingType, TypeRef typeRef, ReferenceType reference) {
            TypeInfo type = symbols.lookupTypeInfoIdentifiers(referencingType, typeRef.getNames(), reference);
            if (typeRef.getTypeArguments().isEmpty()) {
                return GenericTypeInfoUtil.isGenericType(type) ? UnresolvedTypeInfoFactory.create(type, new TypeInfo[0]) : type;
            }
            if (Version.V184.isGreaterThan(referencingType.getCodeUnitDetails().getVersion()) && !typeRef.getTypeArguments().isEmpty() && !GenericTypeInfoUtil.isGenericType(type)) {
                return type;
            }
            List<TypeInfo> types = ClassTypeResolver.getTypesFromTypeRefs(symbols, referencingType, typeRef.getTypeArguments(), reference);
            return GenericTypeInfoFactory.create(symbols, type, types);
        }
    }

    private static class JavaTypeResolver
    implements TypeRefResolver {
        private static final JavaTypeResolver INSTANCE = new JavaTypeResolver();

        private JavaTypeResolver() {
        }

        @Override
        public TypeInfo resolve(SymbolResolver symbols, TypeInfo referencingType, TypeRef typeRef, ReferenceType reference) {
            if (referencingType.getCodeUnitDetails().isTrusted()) {
                String className = PrinterUtil.get().getFactory().dottedIdentifier().print(typeRef.getNames(), PrintContexts.empty());
                Class clazz = JavaTypeInfoUtil.get().lookupClass(className);
                return clazz == null ? UnresolvedTypeInfoFactory.createFromIdentifiers(typeRef.getNames()) : JavaTypeInfoUtil.get().createJava((Class<?>)clazz);
            }
            return UnresolvedTypeInfoFactory.createFromIdentifiers(typeRef.getNames());
        }
    }
}

