/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.ColonExpr;
import apex.jorje.data.soql.DistanceFunctionExpr;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.data.soql.Geolocation;
import apex.jorje.data.soql.NumberClause;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.soql.ColonExprPrinter;
import apex.jorje.services.printers.soql.FieldIdentifierPrinter;
import apex.jorje.services.printers.soql.NumberClausePrinter;

public class DistanceFunctionExprPrinter
implements Printer<DistanceFunctionExpr> {
    private static final Printer<DistanceFunctionExpr> INSTANCE = new DistanceFunctionExprPrinter(FieldIdentifierPrinter.get(), NumberClausePrinter.get(), ColonExprPrinter.get());
    private final Printer<FieldIdentifier> fieldIdentifierPrinter;
    private final Printer<NumberClause> soslNumberClausePrinter;
    private final Printer<ColonExpr> colonExprPrinter;

    private DistanceFunctionExprPrinter(Printer<FieldIdentifier> fieldIdentifierPrinter, Printer<NumberClause> soslNumberClausePrinter, Printer<ColonExpr> colonExprPrinter) {
        this.fieldIdentifierPrinter = fieldIdentifierPrinter;
        this.soslNumberClausePrinter = soslNumberClausePrinter;
        this.colonExprPrinter = colonExprPrinter;
    }

    public static Printer<DistanceFunctionExpr> get() {
        return INSTANCE;
    }

    @Override
    public String print(DistanceFunctionExpr x, final PrintContext ctx) {
        String location = x.location.match(new Geolocation.MatchBlock<String>(){

            @Override
            public String _case(Geolocation.GeolocationLiteral x) {
                return DistanceFunctionExprPrinter.this.soslNumberClausePrinter.print(x.latitude, ctx) + ", " + DistanceFunctionExprPrinter.this.soslNumberClausePrinter.print(x.longitude, ctx);
            }

            @Override
            public String _case(Geolocation.GeolocationExpr x) {
                return DistanceFunctionExprPrinter.this.colonExprPrinter.print(x.expr, ctx);
            }
        });
        return "DISTANCE(" + this.fieldIdentifierPrinter.print(x.field, ctx) + ", GEOLOCATION(" + location + "), '" + x.unit + "')";
    }
}

