/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.pmd.lang.Language;

public class LanguageFilenameFilter
implements FilenameFilter {
    private final Set<Language> languages;

    public LanguageFilenameFilter(Language language) {
        this(Collections.singleton(language));
    }

    public LanguageFilenameFilter(Set<Language> languages) {
        this.languages = languages;
    }

    @Override
    public boolean accept(File dir, String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return false;
        }
        String extension = name.substring(1 + lastDotIndex).toUpperCase(Locale.ROOT);
        for (Language language : this.languages) {
            for (String ext : language.getExtensions()) {
                if (!extension.equalsIgnoreCase(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("(Extension is one of: ");
        for (Language language : this.languages) {
            List<String> extensions = language.getExtensions();
            for (int i = 0; i < extensions.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(extensions.get(i));
            }
        }
        buffer.append(')');
        return buffer.toString();
    }
}

