/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.internal.DeprecatedAttribute;

public class Attribute {
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private final Node parent;
    private final String name;
    private Method method;
    private List<?> value;
    private String stringValue;

    public Attribute(Node parent, String name, Method m) {
        this.parent = parent;
        this.name = name;
        this.method = m;
    }

    public Attribute(Node parent, String name, String value) {
        this.parent = parent;
        this.name = name;
        this.value = Collections.singletonList(value);
        this.stringValue = value;
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    @Experimental
    public Class<?> getType() {
        return this.method == null ? String.class : this.method.getReturnType();
    }

    @InternalApi
    public String replacementIfDeprecated() {
        String result;
        if (this.method == null) {
            return null;
        }
        DeprecatedAttribute annot = this.method.getAnnotation(DeprecatedAttribute.class);
        String string = annot != null ? annot.replaceWith() : (result = this.method.isAnnotationPresent(Deprecated.class) ? "" : null);
        if (result == null && List.class.isAssignableFrom(this.method.getReturnType())) {
            result = "";
        }
        return result;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value.get(0);
        }
        try {
            this.value = Collections.singletonList(this.method.invoke((Object)this.parent, EMPTY_OBJ_ARRAY));
            return this.value.get(0);
        }
        catch (IllegalAccessException | InvocationTargetException iae) {
            iae.printStackTrace();
            return null;
        }
    }

    public String getStringValue() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        Object v = this.getValue();
        this.stringValue = v == null ? "" : String.valueOf(v);
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.parent, attribute.parent) && Objects.equals(this.name, attribute.name);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name);
    }

    public String toString() {
        return this.name + ':' + this.getValue() + ':' + this.parent.getXPathNodeName();
    }
}

