/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualDocumentCopy;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public class VirtualCopy
implements NodeInfo,
SourceLocator {
    protected String systemId;
    protected int documentNumber;
    protected NodeInfo original;
    protected VirtualCopy parent;
    protected NodeInfo root;

    protected VirtualCopy(NodeInfo base) {
        this.original = base;
        this.systemId = base.getBaseURI();
    }

    public static VirtualCopy makeVirtualCopy(NodeInfo original, NodeInfo root) {
        while (original instanceof VirtualCopy) {
            original = ((VirtualCopy)original).original;
        }
        while (root instanceof VirtualCopy) {
            root = ((VirtualCopy)root).original;
        }
        VirtualCopy vc = original.getNodeKind() == 9 ? new VirtualDocumentCopy((DocumentInfo)original) : new VirtualCopy(original);
        vc.root = root;
        return vc;
    }

    protected VirtualCopy wrap(NodeInfo node) {
        return new VirtualCopy(node);
    }

    public void setDocumentNumber(int documentNumber) {
        this.documentNumber = documentNumber;
    }

    public int getNodeKind() {
        return this.original.getNodeKind();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return other instanceof VirtualCopy && this.documentNumber == other.getDocumentNumber() && this.original.isSameNodeInfo(((VirtualCopy)other).original);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return ((Object)this.original).hashCode() ^ this.documentNumber << 19;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getLineNumber() {
        return this.original.getLineNumber();
    }

    public int getColumnNumber() {
        return this.original.getColumnNumber();
    }

    public int compareOrder(NodeInfo other) {
        return this.original.compareOrder(((VirtualCopy)other).original);
    }

    public String getStringValue() {
        return this.original.getStringValue();
    }

    public CharSequence getStringValueCS() {
        return this.original.getStringValueCS();
    }

    public int getNameCode() {
        return this.original.getNameCode();
    }

    public int getFingerprint() {
        return this.original.getFingerprint();
    }

    public String getLocalPart() {
        return this.original.getLocalPart();
    }

    public String getURI() {
        return this.original.getURI();
    }

    public String getPrefix() {
        return this.original.getPrefix();
    }

    public String getDisplayName() {
        return this.original.getDisplayName();
    }

    public Configuration getConfiguration() {
        return this.original.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.original.getNamePool();
    }

    public int getTypeAnnotation() {
        return this.original.getTypeAnnotation();
    }

    public NodeInfo getParent() {
        if (this.original.isSameNodeInfo(this.root)) {
            return null;
        }
        if (this.parent == null) {
            NodeInfo basep = this.original.getParent();
            if (basep == null) {
                return null;
            }
            this.parent = this.wrap(basep);
            this.parent.setDocumentNumber(this.documentNumber);
        }
        return this.parent;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        VirtualCopy newParent = null;
        if (axisNumber == 3 || axisNumber == 2 || axisNumber == 8) {
            newParent = this;
        } else if (axisNumber == 12 || axisNumber == 11 || axisNumber == 7) {
            newParent = this.parent;
        }
        NodeInfo root = Axis.isSubtreeAxis[axisNumber] ? null : this.root;
        return this.makeCopier(this.original.iterateAxis(axisNumber, nodeTest), newParent, root);
    }

    public String getAttributeValue(int fingerprint) {
        return this.original.getAttributeValue(fingerprint);
    }

    public NodeInfo getRoot() {
        NodeInfo n = this;
        NodeInfo p;
        while ((p = n.getParent()) != null) {
            n = p;
        }
        return n;
    }

    public DocumentInfo getDocumentRoot() {
        NodeInfo root = this.getRoot();
        if (root.getNodeKind() == 9) {
            return (DocumentInfo)root;
        }
        return null;
    }

    public boolean hasChildNodes() {
        return this.original.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append("d");
        buffer.append(Integer.toString(this.documentNumber));
        this.original.generateId(buffer);
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        this.original.copy(out, whichNamespaces, copyAnnotations, locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return this.original.getDeclaredNamespaces(buffer);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.original.getTypedValue();
    }

    public Value atomize() throws XPathException {
        return this.original.atomize();
    }

    public boolean isId() {
        return this.original.isId();
    }

    public boolean isIdref() {
        return this.original.isIdref();
    }

    public boolean isNilled() {
        return this.original.isNilled();
    }

    public String getPublicId() {
        return this.original instanceof SourceLocator ? ((SourceLocator)((Object)this.original)).getPublicId() : null;
    }

    protected VirtualCopier makeCopier(AxisIterator axis, VirtualCopy newParent, NodeInfo root) {
        return new VirtualCopier(axis, newParent, root);
    }

    protected class VirtualCopier
    implements AxisIterator {
        protected AxisIterator base;
        private VirtualCopy parent;
        protected NodeInfo subtreeRoot;
        private NodeInfo current;

        public VirtualCopier(AxisIterator base, VirtualCopy parent, NodeInfo subtreeRoot) {
            this.base = base;
            this.parent = parent;
            this.subtreeRoot = subtreeRoot;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            NodeInfo next = (NodeInfo)this.base.next();
            if (next != null) {
                if (this.subtreeRoot != null && !this.isAncestorOrSelf(this.subtreeRoot, next)) {
                    return null;
                }
                VirtualCopy vc = this.createCopy(next, VirtualCopy.this.root);
                vc.parent = this.parent;
                vc.systemId = VirtualCopy.this.systemId;
                vc.documentNumber = VirtualCopy.this.documentNumber;
                next = vc;
            }
            this.current = next;
            return next;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.base.position();
        }

        public void close() {
            this.base.close();
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValueCS();
        }

        public SequenceIterator getAnother() {
            return new VirtualCopier((AxisIterator)this.base.getAnother(), this.parent, this.subtreeRoot);
        }

        public int getProperties() {
            return 0;
        }

        private boolean isAncestorOrSelf(NodeInfo a, NodeInfo d) {
            do {
                if (!a.isSameNodeInfo(d)) continue;
                return true;
            } while ((d = d.getParent()) != null);
            return false;
        }

        protected VirtualCopy createCopy(NodeInfo node, NodeInfo root) {
            return VirtualCopy.makeVirtualCopy(node, root);
        }
    }
}

