/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.util.StringUtil;

public class SimpleRenderer
implements Renderer {
    private String separator;
    private boolean trimLeadingWhitespace;
    public static final String defaultSeparator = "=====================================================================";

    public SimpleRenderer() {
        this(false);
    }

    public SimpleRenderer(boolean trimLeadingWhitespace) {
        this(defaultSeparator);
        this.trimLeadingWhitespace = trimLeadingWhitespace;
    }

    public SimpleRenderer(String theSeparator) {
        this.separator = theSeparator;
    }

    private void renderOn(StringBuffer rpt, Match match) {
        rpt.append("Found a ").append(match.getLineCount()).append(" line (").append(match.getTokenCount()).append(" tokens) duplication in the following files: ").append(PMD.EOL);
        Iterator occurrences = match.iterator();
        while (occurrences.hasNext()) {
            TokenEntry mark = (TokenEntry)occurrences.next();
            rpt.append("Starting at line ").append(mark.getBeginLine()).append(" of ").append(mark.getTokenSrcID()).append(PMD.EOL);
        }
        rpt.append(PMD.EOL);
        String source = match.getSourceCodeSlice();
        if (this.trimLeadingWhitespace) {
            String[] lines = source.split("[" + PMD.EOL + "]");
            int trimDepth = StringUtil.maxCommonLeadingWhitespaceForAll(lines);
            if (trimDepth > 0) {
                lines = StringUtil.trimStartOn(lines, trimDepth);
            }
            for (int i = 0; i < lines.length; ++i) {
                rpt.append(lines[i]).append(PMD.EOL);
            }
            return;
        }
        rpt.append(source).append(PMD.EOL);
    }

    public String render(Iterator matches) {
        StringBuffer rpt = new StringBuffer(300);
        if (matches.hasNext()) {
            this.renderOn(rpt, (Match)matches.next());
        }
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            rpt.append(this.separator).append(PMD.EOL);
            this.renderOn(rpt, match);
        }
        return rpt.toString();
    }
}

