/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import net.sourceforge.pmd.ast.ASTBreakStatement;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTContinueStatement;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTForInit;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTForUpdate;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLabeledStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTStatement;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.Linker;
import net.sourceforge.pmd.dfa.LinkerException;
import net.sourceforge.pmd.dfa.SequenceException;
import net.sourceforge.pmd.dfa.Structure;

public class StatementAndBraceFinder
extends JavaParserVisitorAdapter {
    private Structure dataFlow;

    public void buildDataFlowFor(SimpleJavaNode node) {
        if (!(node instanceof ASTMethodDeclaration) && !(node instanceof ASTConstructorDeclaration)) {
            throw new RuntimeException("Can't build a data flow for anything other than a method or a constructor");
        }
        this.dataFlow = new Structure();
        this.dataFlow.createStartNode(node.getBeginLine());
        this.dataFlow.createNewNode(node);
        node.jjtAccept(this, this.dataFlow);
        this.dataFlow.createEndNode(node.getEndLine());
        Linker linker = new Linker(this.dataFlow.getBraceStack(), this.dataFlow.getContinueBreakReturnStack());
        try {
            linker.computePaths();
        }
        catch (LinkerException e) {
            e.printStackTrace();
        }
        catch (SequenceException e) {
            e.printStackTrace();
        }
    }

    public Object visit(ASTStatementExpression node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        dataFlow.createNewNode(node);
        return super.visit(node, data);
    }

    public Object visit(ASTVariableDeclarator node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        dataFlow.createNewNode(node);
        return super.visit(node, data);
    }

    public Object visit(ASTExpression node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        if (node.jjtGetParent() instanceof ASTIfStatement) {
            dataFlow.createNewNode(node);
            dataFlow.pushOnStack(1, dataFlow.getLast());
        } else if (node.jjtGetParent() instanceof ASTWhileStatement) {
            dataFlow.createNewNode(node);
            dataFlow.pushOnStack(10, dataFlow.getLast());
        } else if (node.jjtGetParent() instanceof ASTSwitchStatement) {
            dataFlow.createNewNode(node);
            dataFlow.pushOnStack(20, dataFlow.getLast());
        } else if (node.jjtGetParent() instanceof ASTForStatement) {
            dataFlow.createNewNode(node);
            dataFlow.pushOnStack(31, dataFlow.getLast());
        } else if (node.jjtGetParent() instanceof ASTDoStatement) {
            dataFlow.createNewNode(node);
            dataFlow.pushOnStack(41, dataFlow.getLast());
        }
        return super.visit(node, data);
    }

    public Object visit(ASTForInit node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        super.visit(node, data);
        dataFlow.pushOnStack(30, dataFlow.getLast());
        this.addForExpressionNode(node, dataFlow);
        return data;
    }

    public Object visit(ASTLabeledStatement node, Object data) {
        this.dataFlow.createNewNode(node);
        this.dataFlow.pushOnStack(60, this.dataFlow.getLast());
        return super.visit(node, data);
    }

    public Object visit(ASTForUpdate node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        this.addForExpressionNode(node, dataFlow);
        super.visit(node, data);
        dataFlow.pushOnStack(32, dataFlow.getLast());
        return data;
    }

    public Object visit(ASTStatement node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        if (node.jjtGetParent() instanceof ASTForStatement) {
            this.addForExpressionNode(node, dataFlow);
            dataFlow.pushOnStack(33, dataFlow.getLast());
        } else if (node.jjtGetParent() instanceof ASTDoStatement) {
            dataFlow.pushOnStack(40, dataFlow.getLast());
            dataFlow.createNewNode((SimpleNode)node.jjtGetParent());
        }
        super.visit(node, data);
        if (node.jjtGetParent() instanceof ASTIfStatement) {
            ASTIfStatement st = (ASTIfStatement)node.jjtGetParent();
            if (!st.hasElse()) {
                dataFlow.pushOnStack(3, dataFlow.getLast());
            } else if (st.hasElse() && !st.jjtGetChild(1).equals(node)) {
                dataFlow.pushOnStack(4, dataFlow.getLast());
            } else {
                dataFlow.pushOnStack(2, dataFlow.getLast());
            }
        } else if (node.jjtGetParent() instanceof ASTWhileStatement) {
            dataFlow.pushOnStack(11, dataFlow.getLast());
        } else if (node.jjtGetParent() instanceof ASTForStatement) {
            dataFlow.pushOnStack(34, dataFlow.getLast());
        } else if (node.jjtGetParent() instanceof ASTLabeledStatement) {
            dataFlow.pushOnStack(61, dataFlow.getLast());
        }
        return data;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        super.visit(node, data);
        dataFlow.pushOnStack(23, dataFlow.getLast());
        return data;
    }

    public Object visit(ASTSwitchLabel node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        if (node.jjtGetNumChildren() == 0) {
            dataFlow.pushOnStack(22, dataFlow.getLast());
        } else {
            dataFlow.pushOnStack(21, dataFlow.getLast());
        }
        return data;
    }

    public Object visit(ASTBreakStatement node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        dataFlow.createNewNode(node);
        dataFlow.pushOnStack(51, dataFlow.getLast());
        return super.visit(node, data);
    }

    public Object visit(ASTContinueStatement node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        dataFlow.createNewNode(node);
        dataFlow.pushOnStack(52, dataFlow.getLast());
        return super.visit(node, data);
    }

    public Object visit(ASTReturnStatement node, Object data) {
        if (!(data instanceof Structure)) {
            return data;
        }
        Structure dataFlow = (Structure)data;
        dataFlow.createNewNode(node);
        dataFlow.pushOnStack(50, dataFlow.getLast());
        return super.visit(node, data);
    }

    private void addForExpressionNode(SimpleNode node, Structure dataFlow) {
        ASTForStatement parent = (ASTForStatement)node.jjtGetParent();
        boolean hasExpressionChild = false;
        boolean hasForInitNode = false;
        boolean hasForUpdateNode = false;
        for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
            if (parent.jjtGetChild(i) instanceof ASTExpression) {
                hasExpressionChild = true;
                continue;
            }
            if (parent.jjtGetChild(i) instanceof ASTForUpdate) {
                hasForUpdateNode = true;
                continue;
            }
            if (!(parent.jjtGetChild(i) instanceof ASTForInit)) continue;
            hasForInitNode = true;
        }
        if (!hasExpressionChild) {
            if (node instanceof ASTForInit) {
                dataFlow.createNewNode(node);
                dataFlow.pushOnStack(31, dataFlow.getLast());
            } else if (node instanceof ASTForUpdate) {
                if (!hasForInitNode) {
                    dataFlow.createNewNode(node);
                    dataFlow.pushOnStack(31, dataFlow.getLast());
                }
            } else if (node instanceof ASTStatement && !hasForInitNode && !hasForUpdateNode) {
                dataFlow.createNewNode(node);
                dataFlow.pushOnStack(31, dataFlow.getLast());
            }
        }
    }
}

