/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTTryStatement;
import net.sourceforge.pmd.ast.ASTVariableInitializer;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class ImmutableField
extends AbstractRule {
    private static final int MUTABLE = 0;
    private static final int IMMUTABLE = 1;
    private static final int CHECKDECL = 2;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map vars = node.getScope().getVariableDeclarations();
        List constructors = this.findAllConstructors(node);
        Iterator i = vars.entrySet().iterator();
        while (i.hasNext()) {
            int result;
            Map.Entry entry = i.next();
            VariableNameDeclaration field = (VariableNameDeclaration)entry.getKey();
            if (field.getAccessNodeParent().isStatic() || !field.getAccessNodeParent().isPrivate() || field.getAccessNodeParent().isFinal() || (result = this.initializedInConstructor((List)entry.getValue(), new HashSet(constructors))) == 0 || result != 1 && (result != 2 || !this.initializedWhenDeclared(field))) continue;
            this.addViolation(data, field.getNode(), field.getImage());
        }
        return super.visit(node, data);
    }

    private boolean initializedWhenDeclared(VariableNameDeclaration field) {
        return !field.getAccessNodeParent().findChildrenOfType(ASTVariableInitializer.class).isEmpty();
    }

    private int initializedInConstructor(List usages, Set allConstructors) {
        int result = 0;
        int methodInitCount = 0;
        HashSet<SimpleNode> consSet = new HashSet<SimpleNode>();
        Iterator j = usages.iterator();
        while (j.hasNext()) {
            NameOccurrence occ = (NameOccurrence)j.next();
            if (!occ.isOnLeftHandSide() && !occ.isSelfAssignment()) continue;
            SimpleNode node = occ.getLocation();
            SimpleNode constructor = (SimpleNode)node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTConstructorDeclaration == null ? ImmutableField.class$("net.sourceforge.pmd.ast.ASTConstructorDeclaration") : class$net$sourceforge$pmd$ast$ASTConstructorDeclaration);
            if (constructor != null) {
                if (this.inLoopOrTry(node)) continue;
                if (this.inAnonymousInnerClass(node)) {
                    ++methodInitCount;
                    continue;
                }
                consSet.add(constructor);
                continue;
            }
            if (node.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? ImmutableField.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration") : class$net$sourceforge$pmd$ast$ASTMethodDeclaration) == null) continue;
            ++methodInitCount;
        }
        if (usages.isEmpty() || methodInitCount == 0 && consSet.isEmpty()) {
            result = 2;
        } else {
            allConstructors.removeAll(consSet);
            if (allConstructors.isEmpty() && methodInitCount == 0) {
                result = 1;
            }
        }
        return result;
    }

    private boolean inLoopOrTry(SimpleNode node) {
        return (SimpleNode)node.getFirstParentOfType(ASTTryStatement.class) != null || (SimpleNode)node.getFirstParentOfType(ASTForStatement.class) != null || (SimpleNode)node.getFirstParentOfType(ASTWhileStatement.class) != null || (SimpleNode)node.getFirstParentOfType(ASTDoStatement.class) != null;
    }

    private boolean inAnonymousInnerClass(SimpleNode node) {
        ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        return parent != null && parent.isAnonymousInnerClass();
    }

    private List findAllConstructors(ASTClassOrInterfaceDeclaration node) {
        ArrayList cons = new ArrayList();
        node.findChildrenOfType(ASTConstructorDeclaration.class, cons, false);
        return cons;
    }
}

