#include "export_objs.h"

#include "../simworld.h"
#include "../dataobj/scenario.h"
#include <string.h>

#include "api_function.h"
#include "api_class.h"

#include "api/api.h"

static karte_t *welt;

void register_export_function(HSQUIRRELVM vm, karte_t *welt_)
{
	welt = welt_;
	script_api::welt = welt_;

	script_api::start_squirrel_type_logging();

	sq_pushroottable(vm);

	sq_pushstring(vm, "gui", -1);
	if (SQ_SUCCEEDED(sq_get(vm, -2))) {
		script_api::register_method(vm, &scenario_t::open_info_win, "open_info_win");
	}
	sq_pop(vm, 1); // class

	export_city(vm);
	export_convoy(vm);
	export_factory(vm);
	export_goods_desc(vm);
	export_halt(vm);
	export_player(vm);
	export_scenario(vm);
	export_settings(vm);
	export_tiles(vm);
	export_world(vm);

	sq_pop(vm, 1); // root table

	script_api::end_squirrel_type_logging();
}
