/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aws.ivy;

import java.io.IOException;
import java.io.InputStream;
import org.apache.ivy.plugins.repository.Resource;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.springframework.aws.ivy.S3RepositoryException;
import org.springframework.aws.ivy.S3Utils;

public class S3Resource
implements Resource {
    private S3Service service;
    private S3Bucket bucket;
    private String key;
    private boolean exists;
    private long contentLength;
    private long lastModified;
    private String name;

    public S3Resource(S3Service service, String uri) {
        this.service = service;
        this.initializeS3(uri);
        this.initalizeResource();
    }

    public Resource clone(String newUri) {
        return new S3Resource(this.service, newUri);
    }

    public boolean exists() {
        return this.exists;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocal() {
        return false;
    }

    public InputStream openStream() throws IOException {
        try {
            return this.service.getObject(this.bucket, this.key).getDataInputStream();
        }
        catch (S3ServiceException e) {
            throw new S3RepositoryException(e);
        }
    }

    private void initializeS3(String uri) {
        this.bucket = S3Utils.getBucket(uri);
        this.key = S3Utils.getKey(uri);
    }

    private void initalizeResource() {
        try {
            S3Object details = this.service.getObjectDetails(this.bucket, this.key);
            this.exists = true;
            this.contentLength = details.getContentLength();
            this.lastModified = details.getLastModifiedDate().getTime();
            this.name = "s3://" + details.getBucketName() + "/" + details.getKey();
        }
        catch (S3ServiceException s3ServiceException) {
            this.exists = false;
            this.contentLength = 0L;
            this.lastModified = 0L;
            this.name = "";
        }
    }

    public String toString() {
        return this.name;
    }
}

