/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jets3tProperties
implements Serializable {
    private static final long serialVersionUID = -822234326095333142L;
    private static final Log log = LogFactory.getLog((Class)Jets3tProperties.class);
    private static final Hashtable propertiesHashtable = new Hashtable();
    private Properties properties = new Properties();
    private boolean loaded = false;

    public static Jets3tProperties getInstance(InputStream inputStream, String propertiesIdentifer) throws IOException {
        Jets3tProperties jets3tProperties = null;
        if (propertiesHashtable.containsKey(propertiesIdentifer)) {
            jets3tProperties = (Jets3tProperties)propertiesHashtable.get(propertiesIdentifer);
        } else {
            jets3tProperties = new Jets3tProperties();
            propertiesHashtable.put(propertiesIdentifer, jets3tProperties);
        }
        jets3tProperties.loadAndReplaceProperties(inputStream, propertiesIdentifer);
        return jets3tProperties;
    }

    public static Jets3tProperties getInstance(String propertiesFileName) {
        Jets3tProperties jets3tProperties = null;
        if (propertiesHashtable.containsKey(propertiesFileName)) {
            jets3tProperties = (Jets3tProperties)propertiesHashtable.get(propertiesFileName);
            return jets3tProperties;
        }
        jets3tProperties = new Jets3tProperties();
        propertiesHashtable.put(propertiesFileName, jets3tProperties);
        InputStream cpIS = jets3tProperties.getClass().getResourceAsStream("/" + propertiesFileName);
        if (cpIS != null) {
            log.debug((Object)("Loading properties from resource in the classpath: " + propertiesFileName));
            try {
                jets3tProperties.loadAndReplaceProperties(cpIS, "Resource '" + propertiesFileName + "' in classpath");
            }
            catch (IOException e) {
                log.error((Object)("Failed to load properties from resource in classpath: " + propertiesFileName), (Throwable)e);
            }
        }
        return jets3tProperties;
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, this.trim(propertyValue));
    }

    public void loadAndReplaceProperties(InputStream inputStream, String propertiesSource) throws IOException {
        Properties newProperties = new Properties();
        newProperties.load(inputStream);
        Iterator<Map.Entry<Object, Object>> propsIter = newProperties.entrySet().iterator();
        while (propsIter.hasNext()) {
            Map.Entry<Object, Object> entry = propsIter.next();
            String propertyName = (String)entry.getKey();
            String propertyValue = (String)entry.getValue();
            if (this.properties.containsKey(propertyName) && !this.properties.getProperty(propertyName).equals(propertyValue)) {
                log.debug((Object)("Over-riding jets3t property [" + propertyName + "=" + propertyValue + "] with value from properties source " + propertiesSource + ". New value: [" + propertyName + "=" + this.trim(propertyValue) + "]"));
            }
            this.properties.put(propertyName, this.trim(propertyValue));
        }
        this.loaded = true;
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public String getStringProperty(String propertyName, String defaultValue) {
        String stringValue = this.trim(this.properties.getProperty(propertyName, defaultValue));
        log.debug((Object)(propertyName + "=" + stringValue));
        return stringValue;
    }

    public long getLongProperty(String propertyName, long defaultValue) throws NumberFormatException {
        String longValue = this.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        log.debug((Object)(propertyName + "=" + longValue));
        return Long.parseLong(longValue);
    }

    public int getIntProperty(String propertyName, int defaultValue) throws NumberFormatException {
        String intValue = this.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        log.debug((Object)(propertyName + "=" + intValue));
        return Integer.parseInt(intValue);
    }

    public boolean getBoolProperty(String propertyName, boolean defaultValue) throws IllegalArgumentException {
        String boolValue = this.trim(this.properties.getProperty(propertyName, String.valueOf(defaultValue)));
        log.debug((Object)(propertyName + "=" + boolValue));
        if ("true".equalsIgnoreCase(boolValue)) {
            return true;
        }
        if ("false".equalsIgnoreCase(boolValue)) {
            return false;
        }
        throw new IllegalArgumentException("Boolean value '" + boolValue + "' for jets3t property '" + propertyName + "' must be 'true' or 'false' (case-insensitive)");
    }

    public boolean containsKey(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return null;
    }
}

