/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.parsing.asm;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MutableAnnotationInvocationHandler
implements InvocationHandler {
    private final Class<? extends Annotation> annoType;
    private final HashMap<String, Object> attributes = new HashMap();
    private final HashMap<String, Class<?>> attributeTypes = new HashMap();

    public MutableAnnotationInvocationHandler(Class<? extends Annotation> annoType) {
        Method[] attribs;
        Method[] methodArray = attribs = annoType.getDeclaredMethods();
        int n = attribs.length;
        int n2 = 0;
        while (n2 < n) {
            Method attrib = methodArray[n2];
            this.attributes.put(attrib.getName(), AnnotationUtils.getDefaultValue(annoType, (String)attrib.getName()));
            this.attributeTypes.put(attrib.getName(), MutableAnnotationInvocationHandler.getAttributeType(annoType, attrib.getName()));
            ++n2;
        }
        this.annoType = annoType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Assert.isInstanceOf(Annotation.class, (Object)proxy);
        String methodName = method.getName();
        if (this.attributes.containsKey(methodName)) {
            return this.attributes.get(methodName);
        }
        if (methodName.equals("annotationType")) {
            return this.annoType;
        }
        if (methodName.equals("toString")) {
            return String.format("@%s(%s)", this.annoType.getName(), this.getAttribs());
        }
        if (methodName.equals("equals")) {
            return this.isEqualTo(proxy, args[0]);
        }
        if (methodName.equals("hashCode")) {
            return this.calculateHashCode(proxy);
        }
        if (methodName.equals("setAttributeValue")) {
            this.attributes.put((String)args[0], args[1]);
            return null;
        }
        if (methodName.equals("getAttributeType")) {
            return this.attributeTypes.get(args[0]);
        }
        throw new UnsupportedOperationException("this proxy does not support method: " + methodName);
    }

    private Object calculateHashCode(Object proxy) {
        int sum = 0;
        for (String attribName : this.attributes.keySet()) {
            Object attribValue = this.attributes.get(attribName);
            int attribNameHashCode = attribName.hashCode();
            int attribValueHashCode = attribValue == null ? 0 : (attribValue.getClass().isArray() ? Arrays.hashCode((Object[])attribValue) : attribValue.hashCode());
            sum += 127 * attribNameHashCode ^ attribValueHashCode;
        }
        return sum;
    }

    private Object isEqualTo(Object proxy, Object other) {
        if (proxy == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.annoType.isAssignableFrom(other.getClass())) {
            return false;
        }
        for (String attribName : this.attributes.keySet()) {
            Object thatVal;
            Object thisVal;
            try {
                thisVal = this.attributes.get(attribName);
                thatVal = other.getClass().getDeclaredMethod(attribName, new Class[0]).invoke(other, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (thisVal == null && thatVal != null) {
                return false;
            }
            if (thatVal == null && thisVal != null) {
                return false;
            }
            if (!(thatVal.getClass().isArray() ? !Arrays.equals((Object[])thatVal, (Object[])thisVal) : (thisVal instanceof Double ? !Double.valueOf((Double)thisVal).equals((double)((Double)thatVal)) : (thisVal instanceof Float ? !Float.valueOf(((Float)thisVal).floatValue()).equals(Float.valueOf(((Float)thatVal).floatValue())) : !thisVal.equals(thatVal))))) continue;
            return false;
        }
        return true;
    }

    private String getAttribs() {
        ArrayList<String> attribs = new ArrayList<String>();
        for (String attribName : this.attributes.keySet()) {
            attribs.add(String.format("%s=%s", attribName, this.attributes.get(attribName)));
        }
        return StringUtils.collectionToDelimitedString(attribs, (String)", ");
    }

    private static Class<?> getAttributeType(Class<? extends Annotation> annotationType, String attributeName) {
        Method method = null;
        try {
            method = annotationType.getDeclaredMethod(attributeName, new Class[0]);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
        }
        return method.getReturnType();
    }
}

