/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.plugin.context;

import java.lang.reflect.Method;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.config.java.plugin.context.ComponentScanDeclaration;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GeneralizedComponentScanBeanDefinitionParser {
    GeneralizedComponentScanBeanDefinitionParser() {
    }

    public void parse(ComponentScanDeclaration scanDec, BeanDefinitionRegistry registry) {
        ClassPathBeanDefinitionScanner scanner = this.configureScanner(registry, scanDec);
        if (scanDec.isAnnotationConfig()) {
            AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)registry);
        }
        try {
            Method doScan = ClassPathBeanDefinitionScanner.class.getDeclaredMethod("doScan", String[].class);
            doScan.setAccessible(true);
            doScan.invoke((Object)scanner, new Object[]{scanDec.getBasePackages()});
        }
        catch (Exception ex) {
            throw new RuntimeException("Error when trying to reflectively invoke scanner.doScan()", ex);
        }
    }

    protected ClassPathBeanDefinitionScanner configureScanner(BeanDefinitionRegistry registry, ComponentScanDeclaration scanDec) {
        ClassPathBeanDefinitionScanner scanner = this.createScanner(registry, scanDec.isUseDefaultFilters());
        if (scanDec.getResourcePattern() != null) {
            scanner.setResourcePattern(scanDec.getResourcePattern());
        }
        try {
            this.parseBeanNameGenerator(scanner, scanDec);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.parseScope(scanner, scanDec);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return scanner;
    }

    protected ClassPathBeanDefinitionScanner createScanner(BeanDefinitionRegistry registry, boolean useDefaultFilters) {
        return new ClassPathBeanDefinitionScanner(registry, useDefaultFilters);
    }

    protected void parseBeanNameGenerator(ClassPathBeanDefinitionScanner scanner, ComponentScanDeclaration scanDec) {
        if (scanDec.getNameGenerator() != null) {
            BeanNameGenerator beanNameGenerator = (BeanNameGenerator)this.instantiateUserDefinedStrategy(scanDec.getNameGenerator(), BeanNameGenerator.class, scanner.getResourceLoader().getClassLoader());
            scanner.setBeanNameGenerator(beanNameGenerator);
        }
    }

    protected void parseScope(ClassPathBeanDefinitionScanner scanner, ComponentScanDeclaration scanDec) {
        if (scanDec.getScopeResolver() != null) {
            if (scanDec.getScopedProxy() != null) {
                throw new IllegalArgumentException("Cannot define both 'scope-resolver' and 'scoped-proxy' on <component-scan> tag");
            }
            ScopeMetadataResolver scopeMetadataResolver = (ScopeMetadataResolver)this.instantiateUserDefinedStrategy(scanDec.getScopeResolver(), ScopeMetadataResolver.class, scanner.getResourceLoader().getClassLoader());
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        scanner.setScopedProxyMode(scanDec.getScopedProxy());
    }

    private Object instantiateUserDefinedStrategy(Class<?> userStrategy, Class<?> strategyType, ClassLoader classLoader) {
        String strategyTypeName = userStrategy.getClass().getTypeParameters()[0].toString();
        String className = userStrategy.getName();
        Object result = null;
        try {
            result = userStrategy.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to instantiate class [" + className + "] for strategy [" + strategyTypeName + "]. A zero-argument constructor is required", ex);
        }
        return result;
    }
}

