/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.model;

import static org.springframework.config.java.internal.util.AnnotationExtractionUtils.extractMethodAnnotation;
import static org.springframework.config.java.internal.util.AnnotationExtractionUtils.findAnnotation;

import org.springframework.config.java.annotation.ExternalBean;
import org.springframework.config.java.internal.util.MethodAnnotationPrototype;

import java.lang.annotation.Annotation;


/** TODO: JAVADOC */
public class ExternalBeanMethod extends AbstractValidatableAnnotatedMethod<ExternalBean> {

    private static final ExternalBean defaultAnno = extractMethodAnnotation(ExternalBean.class, new MethodAnnotationPrototype() {
            @ExternalBean
            public void targetMethod() { }
        }.getClass());

    public ExternalBeanMethod(String name, Annotation... annotations) { this(name, 0, annotations); }

    public ExternalBeanMethod(String name, int modifiers, Annotation... annotations) {
        super(name, modifiers, annotations);
    }

    /**
     * for testing convenience.
     */
    ExternalBeanMethod(String name) { this(name, defaultAnno); }

    /**
     * for testing convenience.
     */
    ExternalBeanMethod(String name, int modifiers) { this(name, modifiers, defaultAnno); }

    public static boolean identifyAsExternalBeanMethod(Annotation[] annotations) {
        return (findAnnotation(ExternalBean.class, annotations) != null);
    }
}
