/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.model;

import static org.springframework.config.java.internal.util.AnnotationExtractionUtils.extractMethodAnnotation;
import static org.springframework.config.java.internal.util.AnnotationExtractionUtils.findAnnotation;

import org.springframework.config.java.annotation.ExternalValue;
import org.springframework.config.java.internal.util.MethodAnnotationPrototype;

import java.lang.annotation.Annotation;


/** TODO: JAVADOC */
public class ExternalValueMethod extends AbstractValidatableAnnotatedMethod<ExternalValue> {

    private static final ExternalValue defaultAnno = extractMethodAnnotation(ExternalValue.class, new MethodAnnotationPrototype() {
            @ExternalValue
            public void targetMethod() { }
        }.getClass());

    public ExternalValueMethod(String name, int modifiers, Annotation... annotations) {
        super(name, modifiers, annotations);
    }

    /**
     * for testing convenience.
     */
    ExternalValueMethod(String name, int modifiers) { this(name, modifiers, defaultAnno); }

    public static boolean identifyAsExternalValueMethod(Annotation[] annotations) {
        return (findAnnotation(ExternalValue.class, annotations) != null);
    }

}
