/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.tx;

import org.springframework.config.java.plugin.AbstractDeclaration;
import org.springframework.config.java.plugin.ProxyTargetClass;
import org.springframework.config.java.plugin.ProxyTargetClassDeclaration;


/** TODO: JAVADOC */
class TxAnnotationDrivenDeclaration extends AbstractDeclaration implements ProxyTargetClassDeclaration {

    private ProxyTargetClass proxyTargetClass = ProxyTargetClass.UNSPECIFIED;

    AopMode mode = AopMode.PROXY;

    String transactionManagerName = "transactionManager";

    private boolean isExplicitlyOrdered = false;

    private int order = 0;


    public AopMode getMode() {
        return mode;
    }

    public void setMode(AopMode mode) {
        this.mode = mode;
    }


    public String getTransactionManagerName() {
        return transactionManagerName;
    }

    public void setTransactionManagerName(String value) {
        this.transactionManagerName = value;
    }


    public ProxyTargetClass getProxyTargetClass() {
        return proxyTargetClass;
    }

    public void setProxyTargetClass(ProxyTargetClass value) {
        this.proxyTargetClass = value;
    }


    public boolean isExplicitlyOrdered() {
        return isExplicitlyOrdered;
    }

    public void setExplicitlyOrdered(boolean value) {
        this.isExplicitlyOrdered = value;
    }


    public Object getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}
