/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.valuesource;


/** TODO: JAVADOC */
public class EnvironmentValueResolver extends AbstractStringBasedValueResolver {

    public static String EXCEPTION_MSG_PREFIX = "Environment variable is not set: ";

    @Override
    public String getString(String name) throws ValueResolutionException {
        String value = System.getenv(name);

        if(value == null)
            throw new ValueResolutionException(name,
                    EXCEPTION_MSG_PREFIX + name);

        return value;
    }

}
