/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.common.config;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.annotation.Lazy;
import org.springframework.config.java.util.DefaultScopes;

import test.common.beans.TestBean;

import java.awt.Point;


/**
 * Base class used across tests for easy reuse of configuration scenarios.
 *
 * @author Rod Johnson
 * @author Chris Beams
 */
@Configuration
public class BaseConfiguration {
    @Bean(scope = DefaultScopes.SINGLETON, lazy = Lazy.FALSE)
    public TestBean tom() {
        TestBean tom = basePerson();
        tom.setName("tom");
        tom.setSpouse(becky());
        return tom;
    }

    @Bean(scope = DefaultScopes.PROTOTYPE)
    public Point prototypePoint() {
        return new Point(3, 4);
    }

    @Bean(scope = DefaultScopes.PROTOTYPE, lazy = Lazy.FALSE)
    public TestBean prototype() {
        TestBean tom = basePerson();
        tom.setName("prototype");
        tom.setSpouse(becky());
        return tom;
    }

    // Parent template mechanism
    protected TestBean basePerson() {
        return new TestBean();
    }

    @Bean
    public TestBean becky() {
        return new TestBean("becky");
    }

    @Bean
    public TestBean dependsOnHidden() {
        return new TestBean(hidden());
    }

    @Bean
    protected TestBean hidden() {
        TestBean hidden = new TestBean();
        hidden.setName("hidden");
        hidden.setSpouse(becky());
        return hidden;
    }
}
