/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.externalvalue.sjc129;

import static org.hamcrest.CoreMatchers.equalTo;

import static org.junit.Assert.assertThat;

import org.junit.Test;

import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.annotation.ExternalValue;
import org.springframework.config.java.annotation.valuesource.PropertiesValueSource;
import org.springframework.config.java.context.JavaConfigApplicationContext;


/**
 * SJC-129 exposed a bug in which declaring Multiple XxxValueSource
 * (then ResourceBundles) annotations causes an IllegalStateException.
 */
public class MultipleValueSourceTests {

    @Test
    public void coalesceValueSourceLocations() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(Config1.class, Config2.class);
        final DataSource dataSource = ctx.getBean(DataSource.class);
        assertThat(dataSource.username, equalTo("cbeams"));
        assertThat(dataSource.password, equalTo("s3cr3t"));
        assertThat(dataSource.url, equalTo("http://config2.com"));
    }

    @Configuration
    @PropertiesValueSource(locations="test/feature/externalvalue/sjc129/config1.properties")
    public static class Config1 {
        @Bean
        public Object foo() { return new Object(); }
    }

    @Configuration
    @PropertiesValueSource(locations="test/feature/externalvalue/sjc129/config2.properties")
    public abstract static class Config2 {
        @Bean
        public DataSource dataSource() { return new DataSource(username(), password(), url()); }

        @ExternalValue
        public abstract String username();

        @ExternalValue
        public abstract String password();

        @ExternalValue
        public abstract String url();
    }

    public static class DataSource {
        final String username, password, url;

        public DataSource(String username, String password, String url) {
            this.username = username;
            this.password = password;
            this.url = url;
        }

    }
}
